package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MediaPlacement(
    audioHostUrl: Optional[String] = Optional.Absent,
    audioFallbackUrl: Optional[String] = Optional.Absent,
    signalingUrl: Optional[String] = Optional.Absent,
    turnControlUrl: Optional[String] = Optional.Absent,
    screenDataUrl: Optional[String] = Optional.Absent,
    screenViewingUrl: Optional[String] = Optional.Absent,
    screenSharingUrl: Optional[String] = Optional.Absent,
    eventIngestionUrl: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.MediaPlacement = {
    import MediaPlacement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.MediaPlacement
      .builder()
      .optionallyWith(audioHostUrl.map(value => value: java.lang.String))(
        _.audioHostUrl
      )
      .optionallyWith(audioFallbackUrl.map(value => value: java.lang.String))(
        _.audioFallbackUrl
      )
      .optionallyWith(signalingUrl.map(value => value: java.lang.String))(
        _.signalingUrl
      )
      .optionallyWith(turnControlUrl.map(value => value: java.lang.String))(
        _.turnControlUrl
      )
      .optionallyWith(screenDataUrl.map(value => value: java.lang.String))(
        _.screenDataUrl
      )
      .optionallyWith(screenViewingUrl.map(value => value: java.lang.String))(
        _.screenViewingUrl
      )
      .optionallyWith(screenSharingUrl.map(value => value: java.lang.String))(
        _.screenSharingUrl
      )
      .optionallyWith(eventIngestionUrl.map(value => value: java.lang.String))(
        _.eventIngestionUrl
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmeetings.model.MediaPlacement.ReadOnly =
    zio.aws.chimesdkmeetings.model.MediaPlacement.wrap(buildAwsValue())
}
object MediaPlacement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.MediaPlacement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.MediaPlacement =
      zio.aws.chimesdkmeetings.model.MediaPlacement(
        audioHostUrl.map(value => value),
        audioFallbackUrl.map(value => value),
        signalingUrl.map(value => value),
        turnControlUrl.map(value => value),
        screenDataUrl.map(value => value),
        screenViewingUrl.map(value => value),
        screenSharingUrl.map(value => value),
        eventIngestionUrl.map(value => value)
      )
    def audioHostUrl: Optional[String]
    def audioFallbackUrl: Optional[String]
    def signalingUrl: Optional[String]
    def turnControlUrl: Optional[String]
    def screenDataUrl: Optional[String]
    def screenViewingUrl: Optional[String]
    def screenSharingUrl: Optional[String]
    def eventIngestionUrl: Optional[String]
    def getAudioHostUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("audioHostUrl", audioHostUrl)
    def getAudioFallbackUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("audioFallbackUrl", audioFallbackUrl)
    def getSignalingUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("signalingUrl", signalingUrl)
    def getTurnControlUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("turnControlUrl", turnControlUrl)
    def getScreenDataUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("screenDataUrl", screenDataUrl)
    def getScreenViewingUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("screenViewingUrl", screenViewingUrl)
    def getScreenSharingUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("screenSharingUrl", screenSharingUrl)
    def getEventIngestionUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventIngestionUrl", eventIngestionUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.MediaPlacement
  ) extends zio.aws.chimesdkmeetings.model.MediaPlacement.ReadOnly {
    override val audioHostUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.audioHostUrl())
      .map(value => value: String)
    override val audioFallbackUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.audioFallbackUrl())
      .map(value => value: String)
    override val signalingUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.signalingUrl())
      .map(value => value: String)
    override val turnControlUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.turnControlUrl())
      .map(value => value: String)
    override val screenDataUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.screenDataUrl())
      .map(value => value: String)
    override val screenViewingUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.screenViewingUrl())
      .map(value => value: String)
    override val screenSharingUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.screenSharingUrl())
      .map(value => value: String)
    override val eventIngestionUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eventIngestionUrl())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.MediaPlacement
  ): zio.aws.chimesdkmeetings.model.MediaPlacement.ReadOnly = new Wrapper(impl)
}
