package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmeetings.model.primitives.GuidString
import scala.jdk.CollectionConverters._
final case class GetMeetingRequest(meetingId: GuidString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.GetMeetingRequest = {
    import GetMeetingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.GetMeetingRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmeetings.model.GetMeetingRequest.ReadOnly =
    zio.aws.chimesdkmeetings.model.GetMeetingRequest.wrap(buildAwsValue())
}
object GetMeetingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.GetMeetingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.GetMeetingRequest =
      zio.aws.chimesdkmeetings.model.GetMeetingRequest(meetingId)
    def meetingId: GuidString
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.GetMeetingRequest
  ) extends zio.aws.chimesdkmeetings.model.GetMeetingRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chimesdkmeetings.model.primitives.GuidString(impl.meetingId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.GetMeetingRequest
  ): zio.aws.chimesdkmeetings.model.GetMeetingRequest.ReadOnly = new Wrapper(
    impl
  )
}
