package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmeetings.model.primitives.GuidString
import scala.jdk.CollectionConverters._
final case class DeleteAttendeeRequest(
    meetingId: GuidString,
    attendeeId: GuidString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.DeleteAttendeeRequest = {
    import DeleteAttendeeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.DeleteAttendeeRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .attendeeId(GuidString.unwrap(attendeeId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.DeleteAttendeeRequest.ReadOnly =
    zio.aws.chimesdkmeetings.model.DeleteAttendeeRequest.wrap(buildAwsValue())
}
object DeleteAttendeeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.DeleteAttendeeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.DeleteAttendeeRequest =
      zio.aws.chimesdkmeetings.model
        .DeleteAttendeeRequest(meetingId, attendeeId)
    def meetingId: GuidString
    def attendeeId: GuidString
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
    def getAttendeeId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(attendeeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.DeleteAttendeeRequest
  ) extends zio.aws.chimesdkmeetings.model.DeleteAttendeeRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chimesdkmeetings.model.primitives.GuidString(impl.meetingId())
    override val attendeeId: GuidString =
      zio.aws.chimesdkmeetings.model.primitives.GuidString(impl.attendeeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.DeleteAttendeeRequest
  ): zio.aws.chimesdkmeetings.model.DeleteAttendeeRequest.ReadOnly =
    new Wrapper(impl)
}
