package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmeetings.model.primitives.{
  JoinTokenString,
  GuidString,
  ExternalUserId
}
import scala.jdk.CollectionConverters._
final case class Attendee(
    externalUserId: Optional[ExternalUserId] = Optional.Absent,
    attendeeId: Optional[GuidString] = Optional.Absent,
    joinToken: Optional[JoinTokenString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.Attendee = {
    import Attendee.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.Attendee
      .builder()
      .optionallyWith(
        externalUserId.map(value =>
          ExternalUserId.unwrap(value): java.lang.String
        )
      )(_.externalUserId)
      .optionallyWith(
        attendeeId.map(value => GuidString.unwrap(value): java.lang.String)
      )(_.attendeeId)
      .optionallyWith(
        joinToken.map(value => JoinTokenString.unwrap(value): java.lang.String)
      )(_.joinToken)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmeetings.model.Attendee.ReadOnly =
    zio.aws.chimesdkmeetings.model.Attendee.wrap(buildAwsValue())
}
object Attendee {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.Attendee
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.Attendee =
      zio.aws.chimesdkmeetings.model.Attendee(
        externalUserId.map(value => value),
        attendeeId.map(value => value),
        joinToken.map(value => value)
      )
    def externalUserId: Optional[ExternalUserId]
    def attendeeId: Optional[GuidString]
    def joinToken: Optional[JoinTokenString]
    def getExternalUserId: ZIO[Any, AwsError, ExternalUserId] =
      AwsError.unwrapOptionField("externalUserId", externalUserId)
    def getAttendeeId: ZIO[Any, AwsError, GuidString] =
      AwsError.unwrapOptionField("attendeeId", attendeeId)
    def getJoinToken: ZIO[Any, AwsError, JoinTokenString] =
      AwsError.unwrapOptionField("joinToken", joinToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.Attendee
  ) extends zio.aws.chimesdkmeetings.model.Attendee.ReadOnly {
    override val externalUserId: Optional[ExternalUserId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalUserId())
        .map(value =>
          zio.aws.chimesdkmeetings.model.primitives.ExternalUserId(value)
        )
    override val attendeeId: Optional[GuidString] = zio.aws.core.internal
      .optionalFromNullable(impl.attendeeId())
      .map(value => zio.aws.chimesdkmeetings.model.primitives.GuidString(value))
    override val joinToken: Optional[JoinTokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.joinToken())
      .map(value =>
        zio.aws.chimesdkmeetings.model.primitives.JoinTokenString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.Attendee
  ): zio.aws.chimesdkmeetings.model.Attendee.ReadOnly = new Wrapper(impl)
}
