package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmeetings.model.primitives.{ExternalUserId, GuidString}
import scala.jdk.CollectionConverters._
final case class CreateAttendeeRequest(
    meetingId: GuidString,
    externalUserId: ExternalUserId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeRequest = {
    import CreateAttendeeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .externalUserId(ExternalUserId.unwrap(externalUserId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.CreateAttendeeRequest.ReadOnly =
    zio.aws.chimesdkmeetings.model.CreateAttendeeRequest.wrap(buildAwsValue())
}
object CreateAttendeeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.CreateAttendeeRequest =
      zio.aws.chimesdkmeetings.model
        .CreateAttendeeRequest(meetingId, externalUserId)
    def meetingId: GuidString
    def externalUserId: ExternalUserId
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
    def getExternalUserId: ZIO[Any, Nothing, ExternalUserId] =
      ZIO.succeed(externalUserId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeRequest
  ) extends zio.aws.chimesdkmeetings.model.CreateAttendeeRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chimesdkmeetings.model.primitives.GuidString(impl.meetingId())
    override val externalUserId: ExternalUserId =
      zio.aws.chimesdkmeetings.model.primitives
        .ExternalUserId(impl.externalUserId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeRequest
  ): zio.aws.chimesdkmeetings.model.CreateAttendeeRequest.ReadOnly =
    new Wrapper(impl)
}
