package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmeetings.model.primitives.GuidString
import scala.jdk.CollectionConverters._
final case class StopMeetingTranscriptionRequest(meetingId: GuidString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.StopMeetingTranscriptionRequest = {
    import StopMeetingTranscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.StopMeetingTranscriptionRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.StopMeetingTranscriptionRequest.ReadOnly =
    zio.aws.chimesdkmeetings.model.StopMeetingTranscriptionRequest
      .wrap(buildAwsValue())
}
object StopMeetingTranscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.StopMeetingTranscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmeetings.model.StopMeetingTranscriptionRequest =
      zio.aws.chimesdkmeetings.model.StopMeetingTranscriptionRequest(meetingId)
    def meetingId: GuidString
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.StopMeetingTranscriptionRequest
  ) extends zio.aws.chimesdkmeetings.model.StopMeetingTranscriptionRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chimesdkmeetings.model.primitives.GuidString(impl.meetingId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.StopMeetingTranscriptionRequest
  ): zio.aws.chimesdkmeetings.model.StopMeetingTranscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
