package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmeetings.model.primitives.GuidString
import scala.jdk.CollectionConverters._
final case class StartMeetingTranscriptionRequest(
    meetingId: GuidString,
    transcriptionConfiguration: zio.aws.chimesdkmeetings.model.TranscriptionConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.StartMeetingTranscriptionRequest = {
    import StartMeetingTranscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.StartMeetingTranscriptionRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .transcriptionConfiguration(transcriptionConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.StartMeetingTranscriptionRequest.ReadOnly =
    zio.aws.chimesdkmeetings.model.StartMeetingTranscriptionRequest
      .wrap(buildAwsValue())
}
object StartMeetingTranscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.StartMeetingTranscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmeetings.model.StartMeetingTranscriptionRequest =
      zio.aws.chimesdkmeetings.model.StartMeetingTranscriptionRequest(
        meetingId,
        transcriptionConfiguration.asEditable
      )
    def meetingId: GuidString
    def transcriptionConfiguration
        : zio.aws.chimesdkmeetings.model.TranscriptionConfiguration.ReadOnly
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
    def getTranscriptionConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmeetings.model.TranscriptionConfiguration.ReadOnly
    ] = ZIO.succeed(transcriptionConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.StartMeetingTranscriptionRequest
  ) extends zio.aws.chimesdkmeetings.model.StartMeetingTranscriptionRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chimesdkmeetings.model.primitives.GuidString(impl.meetingId())
    override val transcriptionConfiguration
        : zio.aws.chimesdkmeetings.model.TranscriptionConfiguration.ReadOnly =
      zio.aws.chimesdkmeetings.model.TranscriptionConfiguration
        .wrap(impl.transcriptionConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.StartMeetingTranscriptionRequest
  ): zio.aws.chimesdkmeetings.model.StartMeetingTranscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
