package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmeetings.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class NotificationsConfiguration(
    lambdaFunctionArn: Option[Arn] = None,
    snsTopicArn: Option[Arn] = None,
    sqsQueueArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.NotificationsConfiguration = {
    import NotificationsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.NotificationsConfiguration
      .builder()
      .optionallyWith(
        lambdaFunctionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.lambdaFunctionArn)
      .optionallyWith(
        snsTopicArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .optionallyWith(
        sqsQueueArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.sqsQueueArn)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.NotificationsConfiguration.ReadOnly =
    zio.aws.chimesdkmeetings.model.NotificationsConfiguration
      .wrap(buildAwsValue())
}
object NotificationsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.NotificationsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.NotificationsConfiguration =
      zio.aws.chimesdkmeetings.model.NotificationsConfiguration(
        lambdaFunctionArn.map(value => value),
        snsTopicArn.map(value => value),
        sqsQueueArn.map(value => value)
      )
    def lambdaFunctionArn: Option[Arn]
    def snsTopicArn: Option[Arn]
    def sqsQueueArn: Option[Arn]
    def getLambdaFunctionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("lambdaFunctionArn", lambdaFunctionArn)
    def getSnsTopicArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getSqsQueueArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("sqsQueueArn", sqsQueueArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.NotificationsConfiguration
  ) extends zio.aws.chimesdkmeetings.model.NotificationsConfiguration.ReadOnly {
    override val lambdaFunctionArn: Option[Arn] = scala
      .Option(impl.lambdaFunctionArn())
      .map(value => zio.aws.chimesdkmeetings.model.primitives.Arn(value))
    override val snsTopicArn: Option[Arn] = scala
      .Option(impl.snsTopicArn())
      .map(value => zio.aws.chimesdkmeetings.model.primitives.Arn(value))
    override val sqsQueueArn: Option[Arn] = scala
      .Option(impl.sqsQueueArn())
      .map(value => zio.aws.chimesdkmeetings.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.NotificationsConfiguration
  ): zio.aws.chimesdkmeetings.model.NotificationsConfiguration.ReadOnly =
    new Wrapper(impl)
}
