package zio.aws.chimesdkmeetings.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmeetings.model.primitives.{ResultMax, GuidString}
import scala.jdk.CollectionConverters._
final case class ListAttendeesRequest(
    meetingId: GuidString,
    nextToken: Option[String] = None,
    maxResults: Option[ResultMax] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.ListAttendeesRequest = {
    import ListAttendeesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.ListAttendeesRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => ResultMax.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmeetings.model.ListAttendeesRequest.ReadOnly =
    zio.aws.chimesdkmeetings.model.ListAttendeesRequest.wrap(buildAwsValue())
}
object ListAttendeesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.ListAttendeesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.ListAttendeesRequest =
      zio.aws.chimesdkmeetings.model.ListAttendeesRequest(
        meetingId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def meetingId: GuidString
    def nextToken: Option[String]
    def maxResults: Option[ResultMax]
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultMax] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.ListAttendeesRequest
  ) extends zio.aws.chimesdkmeetings.model.ListAttendeesRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chimesdkmeetings.model.primitives.GuidString(impl.meetingId())
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[ResultMax] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.chimesdkmeetings.model.primitives.ResultMax(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.ListAttendeesRequest
  ): zio.aws.chimesdkmeetings.model.ListAttendeesRequest.ReadOnly = new Wrapper(
    impl
  )
}
