package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmeetings.model.primitives.{
  TranscribeLanguageOptions,
  TranscribeLanguageModelName,
  TranscribePiiEntityTypes
}
import scala.jdk.CollectionConverters._
final case class EngineTranscribeSettings(
    languageCode: Option[
      zio.aws.chimesdkmeetings.model.TranscribeLanguageCode
    ] = None,
    vocabularyFilterMethod: Option[
      zio.aws.chimesdkmeetings.model.TranscribeVocabularyFilterMethod
    ] = None,
    vocabularyFilterName: Option[String] = None,
    vocabularyName: Option[String] = None,
    region: Option[zio.aws.chimesdkmeetings.model.TranscribeRegion] = None,
    enablePartialResultsStabilization: Option[Boolean] = None,
    partialResultsStability: Option[
      zio.aws.chimesdkmeetings.model.TranscribePartialResultsStability
    ] = None,
    contentIdentificationType: Option[
      zio.aws.chimesdkmeetings.model.TranscribeContentIdentificationType
    ] = None,
    contentRedactionType: Option[
      zio.aws.chimesdkmeetings.model.TranscribeContentRedactionType
    ] = None,
    piiEntityTypes: Option[TranscribePiiEntityTypes] = None,
    languageModelName: Option[TranscribeLanguageModelName] = None,
    identifyLanguage: Option[Boolean] = None,
    languageOptions: Option[TranscribeLanguageOptions] = None,
    preferredLanguage: Option[
      zio.aws.chimesdkmeetings.model.TranscribeLanguageCode
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.EngineTranscribeSettings = {
    import EngineTranscribeSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.EngineTranscribeSettings
      .builder()
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(vocabularyFilterMethod.map(value => value.unwrap))(
        _.vocabularyFilterMethod
      )
      .optionallyWith(
        vocabularyFilterName.map(value => value: java.lang.String)
      )(_.vocabularyFilterName)
      .optionallyWith(vocabularyName.map(value => value: java.lang.String))(
        _.vocabularyName
      )
      .optionallyWith(region.map(value => value.unwrap))(_.region)
      .optionallyWith(
        enablePartialResultsStabilization.map(value => value: java.lang.Boolean)
      )(_.enablePartialResultsStabilization)
      .optionallyWith(partialResultsStability.map(value => value.unwrap))(
        _.partialResultsStability
      )
      .optionallyWith(contentIdentificationType.map(value => value.unwrap))(
        _.contentIdentificationType
      )
      .optionallyWith(contentRedactionType.map(value => value.unwrap))(
        _.contentRedactionType
      )
      .optionallyWith(
        piiEntityTypes.map(value =>
          TranscribePiiEntityTypes.unwrap(value): java.lang.String
        )
      )(_.piiEntityTypes)
      .optionallyWith(
        languageModelName.map(value =>
          TranscribeLanguageModelName.unwrap(value): java.lang.String
        )
      )(_.languageModelName)
      .optionallyWith(identifyLanguage.map(value => value: java.lang.Boolean))(
        _.identifyLanguage
      )
      .optionallyWith(
        languageOptions.map(value =>
          TranscribeLanguageOptions.unwrap(value): java.lang.String
        )
      )(_.languageOptions)
      .optionallyWith(preferredLanguage.map(value => value.unwrap))(
        _.preferredLanguage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.EngineTranscribeSettings.ReadOnly =
    zio.aws.chimesdkmeetings.model.EngineTranscribeSettings
      .wrap(buildAwsValue())
}
object EngineTranscribeSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.EngineTranscribeSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.EngineTranscribeSettings =
      zio.aws.chimesdkmeetings.model.EngineTranscribeSettings(
        languageCode.map(value => value),
        vocabularyFilterMethod.map(value => value),
        vocabularyFilterName.map(value => value),
        vocabularyName.map(value => value),
        region.map(value => value),
        enablePartialResultsStabilization.map(value => value),
        partialResultsStability.map(value => value),
        contentIdentificationType.map(value => value),
        contentRedactionType.map(value => value),
        piiEntityTypes.map(value => value),
        languageModelName.map(value => value),
        identifyLanguage.map(value => value),
        languageOptions.map(value => value),
        preferredLanguage.map(value => value)
      )
    def languageCode
        : Option[zio.aws.chimesdkmeetings.model.TranscribeLanguageCode]
    def vocabularyFilterMethod: Option[
      zio.aws.chimesdkmeetings.model.TranscribeVocabularyFilterMethod
    ]
    def vocabularyFilterName: Option[String]
    def vocabularyName: Option[String]
    def region: Option[zio.aws.chimesdkmeetings.model.TranscribeRegion]
    def enablePartialResultsStabilization: Option[Boolean]
    def partialResultsStability: Option[
      zio.aws.chimesdkmeetings.model.TranscribePartialResultsStability
    ]
    def contentIdentificationType: Option[
      zio.aws.chimesdkmeetings.model.TranscribeContentIdentificationType
    ]
    def contentRedactionType
        : Option[zio.aws.chimesdkmeetings.model.TranscribeContentRedactionType]
    def piiEntityTypes: Option[TranscribePiiEntityTypes]
    def languageModelName: Option[TranscribeLanguageModelName]
    def identifyLanguage: Option[Boolean]
    def languageOptions: Option[TranscribeLanguageOptions]
    def preferredLanguage
        : Option[zio.aws.chimesdkmeetings.model.TranscribeLanguageCode]
    def getLanguageCode: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.TranscribeLanguageCode
    ] = AwsError.unwrapOptionField("languageCode", languageCode)
    def getVocabularyFilterMethod: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.TranscribeVocabularyFilterMethod
    ] = AwsError.unwrapOptionField(
      "vocabularyFilterMethod",
      vocabularyFilterMethod
    )
    def getVocabularyFilterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vocabularyFilterName", vocabularyFilterName)
    def getVocabularyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vocabularyName", vocabularyName)
    def getRegion
        : ZIO[Any, AwsError, zio.aws.chimesdkmeetings.model.TranscribeRegion] =
      AwsError.unwrapOptionField("region", region)
    def getEnablePartialResultsStabilization: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enablePartialResultsStabilization",
        enablePartialResultsStabilization
      )
    def getPartialResultsStability: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.TranscribePartialResultsStability
    ] = AwsError.unwrapOptionField(
      "partialResultsStability",
      partialResultsStability
    )
    def getContentIdentificationType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.TranscribeContentIdentificationType
    ] = AwsError.unwrapOptionField(
      "contentIdentificationType",
      contentIdentificationType
    )
    def getContentRedactionType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.TranscribeContentRedactionType
    ] = AwsError.unwrapOptionField("contentRedactionType", contentRedactionType)
    def getPiiEntityTypes: ZIO[Any, AwsError, TranscribePiiEntityTypes] =
      AwsError.unwrapOptionField("piiEntityTypes", piiEntityTypes)
    def getLanguageModelName: ZIO[Any, AwsError, TranscribeLanguageModelName] =
      AwsError.unwrapOptionField("languageModelName", languageModelName)
    def getIdentifyLanguage: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("identifyLanguage", identifyLanguage)
    def getLanguageOptions: ZIO[Any, AwsError, TranscribeLanguageOptions] =
      AwsError.unwrapOptionField("languageOptions", languageOptions)
    def getPreferredLanguage: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.TranscribeLanguageCode
    ] = AwsError.unwrapOptionField("preferredLanguage", preferredLanguage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.EngineTranscribeSettings
  ) extends zio.aws.chimesdkmeetings.model.EngineTranscribeSettings.ReadOnly {
    override val languageCode
        : Option[zio.aws.chimesdkmeetings.model.TranscribeLanguageCode] = scala
      .Option(impl.languageCode())
      .map(value =>
        zio.aws.chimesdkmeetings.model.TranscribeLanguageCode.wrap(value)
      )
    override val vocabularyFilterMethod: Option[
      zio.aws.chimesdkmeetings.model.TranscribeVocabularyFilterMethod
    ] = scala
      .Option(impl.vocabularyFilterMethod())
      .map(value =>
        zio.aws.chimesdkmeetings.model.TranscribeVocabularyFilterMethod
          .wrap(value)
      )
    override val vocabularyFilterName: Option[String] =
      scala.Option(impl.vocabularyFilterName()).map(value => value: String)
    override val vocabularyName: Option[String] =
      scala.Option(impl.vocabularyName()).map(value => value: String)
    override val region
        : Option[zio.aws.chimesdkmeetings.model.TranscribeRegion] = scala
      .Option(impl.region())
      .map(value => zio.aws.chimesdkmeetings.model.TranscribeRegion.wrap(value))
    override val enablePartialResultsStabilization: Option[Boolean] = scala
      .Option(impl.enablePartialResultsStabilization())
      .map(value => value: Boolean)
    override val partialResultsStability: Option[
      zio.aws.chimesdkmeetings.model.TranscribePartialResultsStability
    ] = scala
      .Option(impl.partialResultsStability())
      .map(value =>
        zio.aws.chimesdkmeetings.model.TranscribePartialResultsStability
          .wrap(value)
      )
    override val contentIdentificationType: Option[
      zio.aws.chimesdkmeetings.model.TranscribeContentIdentificationType
    ] = scala
      .Option(impl.contentIdentificationType())
      .map(value =>
        zio.aws.chimesdkmeetings.model.TranscribeContentIdentificationType
          .wrap(value)
      )
    override val contentRedactionType: Option[
      zio.aws.chimesdkmeetings.model.TranscribeContentRedactionType
    ] = scala
      .Option(impl.contentRedactionType())
      .map(value =>
        zio.aws.chimesdkmeetings.model.TranscribeContentRedactionType
          .wrap(value)
      )
    override val piiEntityTypes: Option[TranscribePiiEntityTypes] = scala
      .Option(impl.piiEntityTypes())
      .map(value =>
        zio.aws.chimesdkmeetings.model.primitives
          .TranscribePiiEntityTypes(value)
      )
    override val languageModelName: Option[TranscribeLanguageModelName] = scala
      .Option(impl.languageModelName())
      .map(value =>
        zio.aws.chimesdkmeetings.model.primitives
          .TranscribeLanguageModelName(value)
      )
    override val identifyLanguage: Option[Boolean] =
      scala.Option(impl.identifyLanguage()).map(value => value: Boolean)
    override val languageOptions: Option[TranscribeLanguageOptions] = scala
      .Option(impl.languageOptions())
      .map(value =>
        zio.aws.chimesdkmeetings.model.primitives
          .TranscribeLanguageOptions(value)
      )
    override val preferredLanguage
        : Option[zio.aws.chimesdkmeetings.model.TranscribeLanguageCode] = scala
      .Option(impl.preferredLanguage())
      .map(value =>
        zio.aws.chimesdkmeetings.model.TranscribeLanguageCode.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.EngineTranscribeSettings
  ): zio.aws.chimesdkmeetings.model.EngineTranscribeSettings.ReadOnly =
    new Wrapper(impl)
}
