package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmeetings.model.primitives.GuidString
import scala.jdk.CollectionConverters._
final case class DeleteMeetingRequest(meetingId: GuidString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.DeleteMeetingRequest = {
    import DeleteMeetingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.DeleteMeetingRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmeetings.model.DeleteMeetingRequest.ReadOnly =
    zio.aws.chimesdkmeetings.model.DeleteMeetingRequest.wrap(buildAwsValue())
}
object DeleteMeetingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.DeleteMeetingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.DeleteMeetingRequest =
      zio.aws.chimesdkmeetings.model.DeleteMeetingRequest(meetingId)
    def meetingId: GuidString
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.DeleteMeetingRequest
  ) extends zio.aws.chimesdkmeetings.model.DeleteMeetingRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chimesdkmeetings.model.primitives.GuidString(impl.meetingId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.DeleteMeetingRequest
  ): zio.aws.chimesdkmeetings.model.DeleteMeetingRequest.ReadOnly = new Wrapper(
    impl
  )
}
