package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmeetings.model.primitives.{
  MediaRegion,
  PrimaryMeetingId,
  ClientRequestToken,
  ExternalMeetingId,
  ExternalUserId
}
import scala.jdk.CollectionConverters._
final case class CreateMeetingRequest(
    clientRequestToken: ClientRequestToken,
    mediaRegion: MediaRegion,
    meetingHostId: Option[ExternalUserId] = None,
    externalMeetingId: ExternalMeetingId,
    notificationsConfiguration: Option[
      zio.aws.chimesdkmeetings.model.NotificationsConfiguration
    ] = None,
    meetingFeatures: Option[
      zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration
    ] = None,
    primaryMeetingId: Option[PrimaryMeetingId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingRequest = {
    import CreateMeetingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingRequest
      .builder()
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .mediaRegion(MediaRegion.unwrap(mediaRegion): java.lang.String)
      .optionallyWith(
        meetingHostId.map(value =>
          ExternalUserId.unwrap(value): java.lang.String
        )
      )(_.meetingHostId)
      .externalMeetingId(
        ExternalMeetingId.unwrap(externalMeetingId): java.lang.String
      )
      .optionallyWith(
        notificationsConfiguration.map(value => value.buildAwsValue())
      )(_.notificationsConfiguration)
      .optionallyWith(meetingFeatures.map(value => value.buildAwsValue()))(
        _.meetingFeatures
      )
      .optionallyWith(
        primaryMeetingId.map(value =>
          PrimaryMeetingId.unwrap(value): java.lang.String
        )
      )(_.primaryMeetingId)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmeetings.model.CreateMeetingRequest.ReadOnly =
    zio.aws.chimesdkmeetings.model.CreateMeetingRequest.wrap(buildAwsValue())
}
object CreateMeetingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.CreateMeetingRequest =
      zio.aws.chimesdkmeetings.model.CreateMeetingRequest(
        clientRequestToken,
        mediaRegion,
        meetingHostId.map(value => value),
        externalMeetingId,
        notificationsConfiguration.map(value => value.asEditable),
        meetingFeatures.map(value => value.asEditable),
        primaryMeetingId.map(value => value)
      )
    def clientRequestToken: ClientRequestToken
    def mediaRegion: MediaRegion
    def meetingHostId: Option[ExternalUserId]
    def externalMeetingId: ExternalMeetingId
    def notificationsConfiguration: Option[
      zio.aws.chimesdkmeetings.model.NotificationsConfiguration.ReadOnly
    ]
    def meetingFeatures: Option[
      zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration.ReadOnly
    ]
    def primaryMeetingId: Option[PrimaryMeetingId]
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
    def getMediaRegion: ZIO[Any, Nothing, MediaRegion] =
      ZIO.succeed(mediaRegion)
    def getMeetingHostId: ZIO[Any, AwsError, ExternalUserId] =
      AwsError.unwrapOptionField("meetingHostId", meetingHostId)
    def getExternalMeetingId: ZIO[Any, Nothing, ExternalMeetingId] =
      ZIO.succeed(externalMeetingId)
    def getNotificationsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.NotificationsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "notificationsConfiguration",
      notificationsConfiguration
    )
    def getMeetingFeatures: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("meetingFeatures", meetingFeatures)
    def getPrimaryMeetingId: ZIO[Any, AwsError, PrimaryMeetingId] =
      AwsError.unwrapOptionField("primaryMeetingId", primaryMeetingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingRequest
  ) extends zio.aws.chimesdkmeetings.model.CreateMeetingRequest.ReadOnly {
    override val clientRequestToken: ClientRequestToken =
      zio.aws.chimesdkmeetings.model.primitives
        .ClientRequestToken(impl.clientRequestToken())
    override val mediaRegion: MediaRegion =
      zio.aws.chimesdkmeetings.model.primitives.MediaRegion(impl.mediaRegion())
    override val meetingHostId: Option[ExternalUserId] = scala
      .Option(impl.meetingHostId())
      .map(value =>
        zio.aws.chimesdkmeetings.model.primitives.ExternalUserId(value)
      )
    override val externalMeetingId: ExternalMeetingId =
      zio.aws.chimesdkmeetings.model.primitives
        .ExternalMeetingId(impl.externalMeetingId())
    override val notificationsConfiguration: Option[
      zio.aws.chimesdkmeetings.model.NotificationsConfiguration.ReadOnly
    ] = scala
      .Option(impl.notificationsConfiguration())
      .map(value =>
        zio.aws.chimesdkmeetings.model.NotificationsConfiguration.wrap(value)
      )
    override val meetingFeatures: Option[
      zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration.ReadOnly
    ] = scala
      .Option(impl.meetingFeatures())
      .map(value =>
        zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration.wrap(value)
      )
    override val primaryMeetingId: Option[PrimaryMeetingId] = scala
      .Option(impl.primaryMeetingId())
      .map(value =>
        zio.aws.chimesdkmeetings.model.primitives.PrimaryMeetingId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingRequest
  ): zio.aws.chimesdkmeetings.model.CreateMeetingRequest.ReadOnly = new Wrapper(
    impl
  )
}
