package zio.aws.chimesdkmeetings
import zio.mock.{Proxy, Mock}
import zio.aws.chimesdkmeetings.model.GetMeetingResponse.ReadOnly
import software.amazon.awssdk.services.chimesdkmeetings.ChimeSdkMeetingsAsyncClient
import zio.aws.chimesdkmeetings.model.{
  CreateMeetingRequest,
  CreateMeetingWithAttendeesRequest,
  StopMeetingTranscriptionRequest,
  GetMeetingRequest,
  ListAttendeesRequest,
  DeleteAttendeeRequest,
  GetAttendeeRequest,
  CreateAttendeeRequest,
  BatchCreateAttendeeRequest,
  StartMeetingTranscriptionRequest,
  DeleteMeetingRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object ChimeSdkMeetingsMock extends Mock[ChimeSdkMeetings] {
  object ListAttendees
      extends Stream[
        ListAttendeesRequest,
        AwsError,
        zio.aws.chimesdkmeetings.model.Attendee.ReadOnly
      ]
  object ListAttendeesPaginated
      extends Effect[
        ListAttendeesRequest,
        AwsError,
        zio.aws.chimesdkmeetings.model.ListAttendeesResponse.ReadOnly
      ]
  object GetMeeting extends Effect[GetMeetingRequest, AwsError, ReadOnly]
  object BatchCreateAttendee
      extends Effect[
        BatchCreateAttendeeRequest,
        AwsError,
        zio.aws.chimesdkmeetings.model.BatchCreateAttendeeResponse.ReadOnly
      ]
  object DeleteMeeting extends Effect[DeleteMeetingRequest, AwsError, Unit]
  object DeleteAttendee extends Effect[DeleteAttendeeRequest, AwsError, Unit]
  object GetAttendee
      extends Effect[
        GetAttendeeRequest,
        AwsError,
        zio.aws.chimesdkmeetings.model.GetAttendeeResponse.ReadOnly
      ]
  object CreateMeeting
      extends Effect[
        CreateMeetingRequest,
        AwsError,
        zio.aws.chimesdkmeetings.model.CreateMeetingResponse.ReadOnly
      ]
  object StartMeetingTranscription
      extends Effect[StartMeetingTranscriptionRequest, AwsError, Unit]
  object CreateMeetingWithAttendees
      extends Effect[
        CreateMeetingWithAttendeesRequest,
        AwsError,
        zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesResponse.ReadOnly
      ]
  object StopMeetingTranscription
      extends Effect[StopMeetingTranscriptionRequest, AwsError, Unit]
  object CreateAttendee
      extends Effect[
        CreateAttendeeRequest,
        AwsError,
        zio.aws.chimesdkmeetings.model.CreateAttendeeResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ChimeSdkMeetings] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new ChimeSdkMeetings {
          val api: ChimeSdkMeetingsAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : ChimeSdkMeetings = this
          def listAttendees(request: ListAttendeesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.chimesdkmeetings.model.Attendee.ReadOnly
          ] = rts.unsafeRun(proxy(ListAttendees, request))
          def listAttendeesPaginated(request: ListAttendeesRequest): IO[
            AwsError,
            zio.aws.chimesdkmeetings.model.ListAttendeesResponse.ReadOnly
          ] = proxy(ListAttendeesPaginated, request)
          def getMeeting(request: GetMeetingRequest): IO[AwsError, ReadOnly] =
            proxy(GetMeeting, request)
          def batchCreateAttendee(request: BatchCreateAttendeeRequest): IO[
            AwsError,
            zio.aws.chimesdkmeetings.model.BatchCreateAttendeeResponse.ReadOnly
          ] = proxy(BatchCreateAttendee, request)
          def deleteMeeting(request: DeleteMeetingRequest): IO[AwsError, Unit] =
            proxy(DeleteMeeting, request)
          def deleteAttendee(
              request: DeleteAttendeeRequest
          ): IO[AwsError, Unit] = proxy(DeleteAttendee, request)
          def getAttendee(request: GetAttendeeRequest): IO[
            AwsError,
            zio.aws.chimesdkmeetings.model.GetAttendeeResponse.ReadOnly
          ] = proxy(GetAttendee, request)
          def createMeeting(request: CreateMeetingRequest): IO[
            AwsError,
            zio.aws.chimesdkmeetings.model.CreateMeetingResponse.ReadOnly
          ] = proxy(CreateMeeting, request)
          def startMeetingTranscription(
              request: StartMeetingTranscriptionRequest
          ): IO[AwsError, Unit] = proxy(StartMeetingTranscription, request)
          def createMeetingWithAttendees(
              request: CreateMeetingWithAttendeesRequest
          ): IO[
            AwsError,
            zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesResponse.ReadOnly
          ] = proxy(CreateMeetingWithAttendees, request)
          def stopMeetingTranscription(
              request: StopMeetingTranscriptionRequest
          ): IO[AwsError, Unit] = proxy(StopMeetingTranscription, request)
          def createAttendee(request: CreateAttendeeRequest): IO[
            AwsError,
            zio.aws.chimesdkmeetings.model.CreateAttendeeResponse.ReadOnly
          ] = proxy(CreateAttendee, request)
        }
      }
    }
    .toLayer
}
