package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmeetings.model.primitives.{
  MediaRegion,
  PrimaryMeetingId,
  GuidString,
  ExternalMeetingId,
  ExternalUserId
}
import scala.jdk.CollectionConverters._
final case class Meeting(
    meetingId: Option[GuidString] = None,
    meetingHostId: Option[ExternalUserId] = None,
    externalMeetingId: Option[ExternalMeetingId] = None,
    mediaRegion: Option[MediaRegion] = None,
    mediaPlacement: Option[zio.aws.chimesdkmeetings.model.MediaPlacement] =
      None,
    meetingFeatures: Option[
      zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration
    ] = None,
    primaryMeetingId: Option[PrimaryMeetingId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.Meeting = {
    import Meeting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.Meeting
      .builder()
      .optionallyWith(
        meetingId.map(value => GuidString.unwrap(value): java.lang.String)
      )(_.meetingId)
      .optionallyWith(
        meetingHostId.map(value =>
          ExternalUserId.unwrap(value): java.lang.String
        )
      )(_.meetingHostId)
      .optionallyWith(
        externalMeetingId.map(value =>
          ExternalMeetingId.unwrap(value): java.lang.String
        )
      )(_.externalMeetingId)
      .optionallyWith(
        mediaRegion.map(value => MediaRegion.unwrap(value): java.lang.String)
      )(_.mediaRegion)
      .optionallyWith(mediaPlacement.map(value => value.buildAwsValue()))(
        _.mediaPlacement
      )
      .optionallyWith(meetingFeatures.map(value => value.buildAwsValue()))(
        _.meetingFeatures
      )
      .optionallyWith(
        primaryMeetingId.map(value =>
          PrimaryMeetingId.unwrap(value): java.lang.String
        )
      )(_.primaryMeetingId)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmeetings.model.Meeting.ReadOnly =
    zio.aws.chimesdkmeetings.model.Meeting.wrap(buildAwsValue())
}
object Meeting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.Meeting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.Meeting =
      zio.aws.chimesdkmeetings.model.Meeting(
        meetingId.map(value => value),
        meetingHostId.map(value => value),
        externalMeetingId.map(value => value),
        mediaRegion.map(value => value),
        mediaPlacement.map(value => value.asEditable),
        meetingFeatures.map(value => value.asEditable),
        primaryMeetingId.map(value => value)
      )
    def meetingId: Option[GuidString]
    def meetingHostId: Option[ExternalUserId]
    def externalMeetingId: Option[ExternalMeetingId]
    def mediaRegion: Option[MediaRegion]
    def mediaPlacement
        : Option[zio.aws.chimesdkmeetings.model.MediaPlacement.ReadOnly]
    def meetingFeatures: Option[
      zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration.ReadOnly
    ]
    def primaryMeetingId: Option[PrimaryMeetingId]
    def getMeetingId: ZIO[Any, AwsError, GuidString] =
      AwsError.unwrapOptionField("meetingId", meetingId)
    def getMeetingHostId: ZIO[Any, AwsError, ExternalUserId] =
      AwsError.unwrapOptionField("meetingHostId", meetingHostId)
    def getExternalMeetingId: ZIO[Any, AwsError, ExternalMeetingId] =
      AwsError.unwrapOptionField("externalMeetingId", externalMeetingId)
    def getMediaRegion: ZIO[Any, AwsError, MediaRegion] =
      AwsError.unwrapOptionField("mediaRegion", mediaRegion)
    def getMediaPlacement: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.MediaPlacement.ReadOnly
    ] = AwsError.unwrapOptionField("mediaPlacement", mediaPlacement)
    def getMeetingFeatures: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("meetingFeatures", meetingFeatures)
    def getPrimaryMeetingId: ZIO[Any, AwsError, PrimaryMeetingId] =
      AwsError.unwrapOptionField("primaryMeetingId", primaryMeetingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.Meeting
  ) extends zio.aws.chimesdkmeetings.model.Meeting.ReadOnly {
    override val meetingId: Option[GuidString] = scala
      .Option(impl.meetingId())
      .map(value => zio.aws.chimesdkmeetings.model.primitives.GuidString(value))
    override val meetingHostId: Option[ExternalUserId] = scala
      .Option(impl.meetingHostId())
      .map(value =>
        zio.aws.chimesdkmeetings.model.primitives.ExternalUserId(value)
      )
    override val externalMeetingId: Option[ExternalMeetingId] = scala
      .Option(impl.externalMeetingId())
      .map(value =>
        zio.aws.chimesdkmeetings.model.primitives.ExternalMeetingId(value)
      )
    override val mediaRegion: Option[MediaRegion] = scala
      .Option(impl.mediaRegion())
      .map(value =>
        zio.aws.chimesdkmeetings.model.primitives.MediaRegion(value)
      )
    override val mediaPlacement
        : Option[zio.aws.chimesdkmeetings.model.MediaPlacement.ReadOnly] = scala
      .Option(impl.mediaPlacement())
      .map(value => zio.aws.chimesdkmeetings.model.MediaPlacement.wrap(value))
    override val meetingFeatures: Option[
      zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration.ReadOnly
    ] = scala
      .Option(impl.meetingFeatures())
      .map(value =>
        zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration.wrap(value)
      )
    override val primaryMeetingId: Option[PrimaryMeetingId] = scala
      .Option(impl.primaryMeetingId())
      .map(value =>
        zio.aws.chimesdkmeetings.model.primitives.PrimaryMeetingId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.Meeting
  ): zio.aws.chimesdkmeetings.model.Meeting.ReadOnly = new Wrapper(impl)
}
