package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetMeetingResponse(
    meeting: Option[zio.aws.chimesdkmeetings.model.Meeting] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.GetMeetingResponse = {
    import GetMeetingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.GetMeetingResponse
      .builder()
      .optionallyWith(meeting.map(value => value.buildAwsValue()))(_.meeting)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmeetings.model.GetMeetingResponse.ReadOnly =
    zio.aws.chimesdkmeetings.model.GetMeetingResponse.wrap(buildAwsValue())
}
object GetMeetingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.GetMeetingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.GetMeetingResponse =
      zio.aws.chimesdkmeetings.model
        .GetMeetingResponse(meeting.map(value => value.asEditable))
    def meeting: Option[zio.aws.chimesdkmeetings.model.Meeting.ReadOnly]
    def getMeeting
        : ZIO[Any, AwsError, zio.aws.chimesdkmeetings.model.Meeting.ReadOnly] =
      AwsError.unwrapOptionField("meeting", meeting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.GetMeetingResponse
  ) extends zio.aws.chimesdkmeetings.model.GetMeetingResponse.ReadOnly {
    override val meeting
        : Option[zio.aws.chimesdkmeetings.model.Meeting.ReadOnly] = scala
      .Option(impl.meeting())
      .map(value => zio.aws.chimesdkmeetings.model.Meeting.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.GetMeetingResponse
  ): zio.aws.chimesdkmeetings.model.GetMeetingResponse.ReadOnly = new Wrapper(
    impl
  )
}
