package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmeetings.model.primitives.ExternalUserId
import scala.jdk.CollectionConverters._
final case class CreateAttendeeError(
    externalUserId: Option[ExternalUserId] = None,
    errorCode: Option[String] = None,
    errorMessage: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeError = {
    import CreateAttendeeError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeError
      .builder()
      .optionallyWith(
        externalUserId.map(value =>
          ExternalUserId.unwrap(value): java.lang.String
        )
      )(_.externalUserId)
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmeetings.model.CreateAttendeeError.ReadOnly =
    zio.aws.chimesdkmeetings.model.CreateAttendeeError.wrap(buildAwsValue())
}
object CreateAttendeeError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.CreateAttendeeError =
      zio.aws.chimesdkmeetings.model.CreateAttendeeError(
        externalUserId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def externalUserId: Option[ExternalUserId]
    def errorCode: Option[String]
    def errorMessage: Option[String]
    def getExternalUserId: ZIO[Any, AwsError, ExternalUserId] =
      AwsError.unwrapOptionField("externalUserId", externalUserId)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeError
  ) extends zio.aws.chimesdkmeetings.model.CreateAttendeeError.ReadOnly {
    override val externalUserId: Option[ExternalUserId] = scala
      .Option(impl.externalUserId())
      .map(value =>
        zio.aws.chimesdkmeetings.model.primitives.ExternalUserId(value)
      )
    override val errorCode: Option[String] =
      scala.Option(impl.errorCode()).map(value => value: String)
    override val errorMessage: Option[String] =
      scala.Option(impl.errorMessage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeError
  ): zio.aws.chimesdkmeetings.model.CreateAttendeeError.ReadOnly = new Wrapper(
    impl
  )
}
