package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchCreateAttendeeResponse(
    attendees: Option[Iterable[zio.aws.chimesdkmeetings.model.Attendee]] = None,
    errors: Option[
      Iterable[zio.aws.chimesdkmeetings.model.CreateAttendeeError]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.BatchCreateAttendeeResponse = {
    import BatchCreateAttendeeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.BatchCreateAttendeeResponse
      .builder()
      .optionallyWith(
        attendees.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attendees)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.BatchCreateAttendeeResponse.ReadOnly =
    zio.aws.chimesdkmeetings.model.BatchCreateAttendeeResponse
      .wrap(buildAwsValue())
}
object BatchCreateAttendeeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.BatchCreateAttendeeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.BatchCreateAttendeeResponse =
      zio.aws.chimesdkmeetings.model.BatchCreateAttendeeResponse(
        attendees.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def attendees
        : Option[List[zio.aws.chimesdkmeetings.model.Attendee.ReadOnly]]
    def errors: Option[
      List[zio.aws.chimesdkmeetings.model.CreateAttendeeError.ReadOnly]
    ]
    def getAttendees: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmeetings.model.Attendee.ReadOnly
    ]] = AwsError.unwrapOptionField("attendees", attendees)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmeetings.model.CreateAttendeeError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.BatchCreateAttendeeResponse
  ) extends zio.aws.chimesdkmeetings.model.BatchCreateAttendeeResponse.ReadOnly {
    override val attendees
        : Option[List[zio.aws.chimesdkmeetings.model.Attendee.ReadOnly]] = scala
      .Option(impl.attendees())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmeetings.model.Attendee.wrap(item)
        }.toList
      )
    override val errors: Option[
      List[zio.aws.chimesdkmeetings.model.CreateAttendeeError.ReadOnly]
    ] = scala
      .Option(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmeetings.model.CreateAttendeeError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.BatchCreateAttendeeResponse
  ): zio.aws.chimesdkmeetings.model.BatchCreateAttendeeResponse.ReadOnly =
    new Wrapper(impl)
}
