package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MediaPlacement(
    audioHostUrl: Option[String] = None,
    audioFallbackUrl: Option[String] = None,
    signalingUrl: Option[String] = None,
    turnControlUrl: Option[String] = None,
    screenDataUrl: Option[String] = None,
    screenViewingUrl: Option[String] = None,
    screenSharingUrl: Option[String] = None,
    eventIngestionUrl: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.MediaPlacement = {
    import MediaPlacement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.MediaPlacement
      .builder()
      .optionallyWith(audioHostUrl.map(value => value: java.lang.String))(
        _.audioHostUrl
      )
      .optionallyWith(audioFallbackUrl.map(value => value: java.lang.String))(
        _.audioFallbackUrl
      )
      .optionallyWith(signalingUrl.map(value => value: java.lang.String))(
        _.signalingUrl
      )
      .optionallyWith(turnControlUrl.map(value => value: java.lang.String))(
        _.turnControlUrl
      )
      .optionallyWith(screenDataUrl.map(value => value: java.lang.String))(
        _.screenDataUrl
      )
      .optionallyWith(screenViewingUrl.map(value => value: java.lang.String))(
        _.screenViewingUrl
      )
      .optionallyWith(screenSharingUrl.map(value => value: java.lang.String))(
        _.screenSharingUrl
      )
      .optionallyWith(eventIngestionUrl.map(value => value: java.lang.String))(
        _.eventIngestionUrl
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmeetings.model.MediaPlacement.ReadOnly =
    zio.aws.chimesdkmeetings.model.MediaPlacement.wrap(buildAwsValue())
}
object MediaPlacement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.MediaPlacement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.MediaPlacement =
      zio.aws.chimesdkmeetings.model.MediaPlacement(
        audioHostUrl.map(value => value),
        audioFallbackUrl.map(value => value),
        signalingUrl.map(value => value),
        turnControlUrl.map(value => value),
        screenDataUrl.map(value => value),
        screenViewingUrl.map(value => value),
        screenSharingUrl.map(value => value),
        eventIngestionUrl.map(value => value)
      )
    def audioHostUrl: Option[String]
    def audioFallbackUrl: Option[String]
    def signalingUrl: Option[String]
    def turnControlUrl: Option[String]
    def screenDataUrl: Option[String]
    def screenViewingUrl: Option[String]
    def screenSharingUrl: Option[String]
    def eventIngestionUrl: Option[String]
    def getAudioHostUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("audioHostUrl", audioHostUrl)
    def getAudioFallbackUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("audioFallbackUrl", audioFallbackUrl)
    def getSignalingUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("signalingUrl", signalingUrl)
    def getTurnControlUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("turnControlUrl", turnControlUrl)
    def getScreenDataUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("screenDataUrl", screenDataUrl)
    def getScreenViewingUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("screenViewingUrl", screenViewingUrl)
    def getScreenSharingUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("screenSharingUrl", screenSharingUrl)
    def getEventIngestionUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventIngestionUrl", eventIngestionUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.MediaPlacement
  ) extends zio.aws.chimesdkmeetings.model.MediaPlacement.ReadOnly {
    override val audioHostUrl: Option[String] =
      scala.Option(impl.audioHostUrl()).map(value => value: String)
    override val audioFallbackUrl: Option[String] =
      scala.Option(impl.audioFallbackUrl()).map(value => value: String)
    override val signalingUrl: Option[String] =
      scala.Option(impl.signalingUrl()).map(value => value: String)
    override val turnControlUrl: Option[String] =
      scala.Option(impl.turnControlUrl()).map(value => value: String)
    override val screenDataUrl: Option[String] =
      scala.Option(impl.screenDataUrl()).map(value => value: String)
    override val screenViewingUrl: Option[String] =
      scala.Option(impl.screenViewingUrl()).map(value => value: String)
    override val screenSharingUrl: Option[String] =
      scala.Option(impl.screenSharingUrl()).map(value => value: String)
    override val eventIngestionUrl: Option[String] =
      scala.Option(impl.eventIngestionUrl()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.MediaPlacement
  ): zio.aws.chimesdkmeetings.model.MediaPlacement.ReadOnly = new Wrapper(impl)
}
