package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAttendeesResponse(
    attendees: Option[Iterable[zio.aws.chimesdkmeetings.model.Attendee]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.ListAttendeesResponse = {
    import ListAttendeesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.ListAttendeesResponse
      .builder()
      .optionallyWith(
        attendees.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attendees)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.ListAttendeesResponse.ReadOnly =
    zio.aws.chimesdkmeetings.model.ListAttendeesResponse.wrap(buildAwsValue())
}
object ListAttendeesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.ListAttendeesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.ListAttendeesResponse =
      zio.aws.chimesdkmeetings.model.ListAttendeesResponse(
        attendees.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def attendees
        : Option[List[zio.aws.chimesdkmeetings.model.Attendee.ReadOnly]]
    def nextToken: Option[String]
    def getAttendees: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmeetings.model.Attendee.ReadOnly
    ]] = AwsError.unwrapOptionField("attendees", attendees)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.ListAttendeesResponse
  ) extends zio.aws.chimesdkmeetings.model.ListAttendeesResponse.ReadOnly {
    override val attendees
        : Option[List[zio.aws.chimesdkmeetings.model.Attendee.ReadOnly]] = scala
      .Option(impl.attendees())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmeetings.model.Attendee.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.ListAttendeesResponse
  ): zio.aws.chimesdkmeetings.model.ListAttendeesResponse.ReadOnly =
    new Wrapper(impl)
}
