package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateMeetingWithAttendeesResponse(
    meeting: Option[zio.aws.chimesdkmeetings.model.Meeting] = None,
    attendees: Option[Iterable[zio.aws.chimesdkmeetings.model.Attendee]] = None,
    errors: Option[
      Iterable[zio.aws.chimesdkmeetings.model.CreateAttendeeError]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingWithAttendeesResponse = {
    import CreateMeetingWithAttendeesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingWithAttendeesResponse
      .builder()
      .optionallyWith(meeting.map(value => value.buildAwsValue()))(_.meeting)
      .optionallyWith(
        attendees.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attendees)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesResponse.ReadOnly =
    zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesResponse
      .wrap(buildAwsValue())
}
object CreateMeetingWithAttendeesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingWithAttendeesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesResponse =
      zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesResponse(
        meeting.map(value => value.asEditable),
        attendees.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def meeting: Option[zio.aws.chimesdkmeetings.model.Meeting.ReadOnly]
    def attendees
        : Option[List[zio.aws.chimesdkmeetings.model.Attendee.ReadOnly]]
    def errors: Option[
      List[zio.aws.chimesdkmeetings.model.CreateAttendeeError.ReadOnly]
    ]
    def getMeeting
        : ZIO[Any, AwsError, zio.aws.chimesdkmeetings.model.Meeting.ReadOnly] =
      AwsError.unwrapOptionField("meeting", meeting)
    def getAttendees: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmeetings.model.Attendee.ReadOnly
    ]] = AwsError.unwrapOptionField("attendees", attendees)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmeetings.model.CreateAttendeeError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingWithAttendeesResponse
  ) extends zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesResponse.ReadOnly {
    override val meeting
        : Option[zio.aws.chimesdkmeetings.model.Meeting.ReadOnly] = scala
      .Option(impl.meeting())
      .map(value => zio.aws.chimesdkmeetings.model.Meeting.wrap(value))
    override val attendees
        : Option[List[zio.aws.chimesdkmeetings.model.Attendee.ReadOnly]] = scala
      .Option(impl.attendees())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmeetings.model.Attendee.wrap(item)
        }.toList
      )
    override val errors: Option[
      List[zio.aws.chimesdkmeetings.model.CreateAttendeeError.ReadOnly]
    ] = scala
      .Option(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmeetings.model.CreateAttendeeError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingWithAttendeesResponse
  ): zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesResponse.ReadOnly =
    new Wrapper(impl)
}
