package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmeetings.model.primitives.{
  ExternalMeetingId,
  ExternalUserId,
  MediaRegion,
  ClientRequestToken
}
import scala.jdk.CollectionConverters._
final case class CreateMeetingWithAttendeesRequest(
    clientRequestToken: ClientRequestToken,
    mediaRegion: MediaRegion,
    meetingHostId: Option[ExternalUserId] = None,
    externalMeetingId: ExternalMeetingId,
    meetingFeatures: Option[
      zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration
    ] = None,
    notificationsConfiguration: Option[
      zio.aws.chimesdkmeetings.model.NotificationsConfiguration
    ] = None,
    attendees: Iterable[
      zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest = {
    import CreateMeetingWithAttendeesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest
      .builder()
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .mediaRegion(MediaRegion.unwrap(mediaRegion): java.lang.String)
      .optionallyWith(
        meetingHostId.map(value =>
          ExternalUserId.unwrap(value): java.lang.String
        )
      )(_.meetingHostId)
      .externalMeetingId(
        ExternalMeetingId.unwrap(externalMeetingId): java.lang.String
      )
      .optionallyWith(meetingFeatures.map(value => value.buildAwsValue()))(
        _.meetingFeatures
      )
      .optionallyWith(
        notificationsConfiguration.map(value => value.buildAwsValue())
      )(_.notificationsConfiguration)
      .attendees(attendees.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest.ReadOnly =
    zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest
      .wrap(buildAwsValue())
}
object CreateMeetingWithAttendeesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest =
      zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest(
        clientRequestToken,
        mediaRegion,
        meetingHostId.map(value => value),
        externalMeetingId,
        meetingFeatures.map(value => value.asEditable),
        notificationsConfiguration.map(value => value.asEditable),
        attendees.map { item =>
          item.asEditable
        }
      )
    def clientRequestToken: ClientRequestToken
    def mediaRegion: MediaRegion
    def meetingHostId: Option[ExternalUserId]
    def externalMeetingId: ExternalMeetingId
    def meetingFeatures: Option[
      zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration.ReadOnly
    ]
    def notificationsConfiguration: Option[
      zio.aws.chimesdkmeetings.model.NotificationsConfiguration.ReadOnly
    ]
    def attendees: List[
      zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem.ReadOnly
    ]
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
    def getMediaRegion: ZIO[Any, Nothing, MediaRegion] =
      ZIO.succeed(mediaRegion)
    def getMeetingHostId: ZIO[Any, AwsError, ExternalUserId] =
      AwsError.unwrapOptionField("meetingHostId", meetingHostId)
    def getExternalMeetingId: ZIO[Any, Nothing, ExternalMeetingId] =
      ZIO.succeed(externalMeetingId)
    def getMeetingFeatures: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("meetingFeatures", meetingFeatures)
    def getNotificationsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.NotificationsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "notificationsConfiguration",
      notificationsConfiguration
    )
    def getAttendees: ZIO[Any, Nothing, List[
      zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem.ReadOnly
    ]] = ZIO.succeed(attendees)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest
  ) extends zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest.ReadOnly {
    override val clientRequestToken: ClientRequestToken =
      zio.aws.chimesdkmeetings.model.primitives
        .ClientRequestToken(impl.clientRequestToken())
    override val mediaRegion: MediaRegion =
      zio.aws.chimesdkmeetings.model.primitives.MediaRegion(impl.mediaRegion())
    override val meetingHostId: Option[ExternalUserId] = scala
      .Option(impl.meetingHostId())
      .map(value =>
        zio.aws.chimesdkmeetings.model.primitives.ExternalUserId(value)
      )
    override val externalMeetingId: ExternalMeetingId =
      zio.aws.chimesdkmeetings.model.primitives
        .ExternalMeetingId(impl.externalMeetingId())
    override val meetingFeatures: Option[
      zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration.ReadOnly
    ] = scala
      .Option(impl.meetingFeatures())
      .map(value =>
        zio.aws.chimesdkmeetings.model.MeetingFeaturesConfiguration.wrap(value)
      )
    override val notificationsConfiguration: Option[
      zio.aws.chimesdkmeetings.model.NotificationsConfiguration.ReadOnly
    ] = scala
      .Option(impl.notificationsConfiguration())
      .map(value =>
        zio.aws.chimesdkmeetings.model.NotificationsConfiguration.wrap(value)
      )
    override val attendees: List[
      zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem.ReadOnly
    ] = impl
      .attendees()
      .asScala
      .map { item =>
        zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest
  ): zio.aws.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest.ReadOnly =
    new Wrapper(impl)
}
