package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AudioFeatures(
    echoReduction: Option[zio.aws.chimesdkmeetings.model.MeetingFeatureStatus] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.AudioFeatures = {
    import AudioFeatures.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.AudioFeatures
      .builder()
      .optionallyWith(echoReduction.map(value => value.unwrap))(_.echoReduction)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmeetings.model.AudioFeatures.ReadOnly =
    zio.aws.chimesdkmeetings.model.AudioFeatures.wrap(buildAwsValue())
}
object AudioFeatures {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.AudioFeatures
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.AudioFeatures =
      zio.aws.chimesdkmeetings.model
        .AudioFeatures(echoReduction.map(value => value))
    def echoReduction
        : Option[zio.aws.chimesdkmeetings.model.MeetingFeatureStatus]
    def getEchoReduction: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.MeetingFeatureStatus
    ] = AwsError.unwrapOptionField("echoReduction", echoReduction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.AudioFeatures
  ) extends zio.aws.chimesdkmeetings.model.AudioFeatures.ReadOnly {
    override val echoReduction
        : Option[zio.aws.chimesdkmeetings.model.MeetingFeatureStatus] = scala
      .Option(impl.echoReduction())
      .map(value =>
        zio.aws.chimesdkmeetings.model.MeetingFeatureStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.AudioFeatures
  ): zio.aws.chimesdkmeetings.model.AudioFeatures.ReadOnly = new Wrapper(impl)
}
