package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetAttendeeResponse(
    attendee: Option[zio.aws.chimesdkmeetings.model.Attendee] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.GetAttendeeResponse = {
    import GetAttendeeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.GetAttendeeResponse
      .builder()
      .optionallyWith(attendee.map(value => value.buildAwsValue()))(_.attendee)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmeetings.model.GetAttendeeResponse.ReadOnly =
    zio.aws.chimesdkmeetings.model.GetAttendeeResponse.wrap(buildAwsValue())
}
object GetAttendeeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.GetAttendeeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.GetAttendeeResponse =
      zio.aws.chimesdkmeetings.model
        .GetAttendeeResponse(attendee.map(value => value.asEditable))
    def attendee: Option[zio.aws.chimesdkmeetings.model.Attendee.ReadOnly]
    def getAttendee
        : ZIO[Any, AwsError, zio.aws.chimesdkmeetings.model.Attendee.ReadOnly] =
      AwsError.unwrapOptionField("attendee", attendee)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.GetAttendeeResponse
  ) extends zio.aws.chimesdkmeetings.model.GetAttendeeResponse.ReadOnly {
    override val attendee
        : Option[zio.aws.chimesdkmeetings.model.Attendee.ReadOnly] = scala
      .Option(impl.attendee())
      .map(value => zio.aws.chimesdkmeetings.model.Attendee.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.GetAttendeeResponse
  ): zio.aws.chimesdkmeetings.model.GetAttendeeResponse.ReadOnly = new Wrapper(
    impl
  )
}
