package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateAttendeeResponse(
    attendee: Option[zio.aws.chimesdkmeetings.model.Attendee] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeResponse = {
    import CreateAttendeeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeResponse
      .builder()
      .optionallyWith(attendee.map(value => value.buildAwsValue()))(_.attendee)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.CreateAttendeeResponse.ReadOnly =
    zio.aws.chimesdkmeetings.model.CreateAttendeeResponse.wrap(buildAwsValue())
}
object CreateAttendeeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.CreateAttendeeResponse =
      zio.aws.chimesdkmeetings.model
        .CreateAttendeeResponse(attendee.map(value => value.asEditable))
    def attendee: Option[zio.aws.chimesdkmeetings.model.Attendee.ReadOnly]
    def getAttendee
        : ZIO[Any, AwsError, zio.aws.chimesdkmeetings.model.Attendee.ReadOnly] =
      AwsError.unwrapOptionField("attendee", attendee)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeResponse
  ) extends zio.aws.chimesdkmeetings.model.CreateAttendeeResponse.ReadOnly {
    override val attendee
        : Option[zio.aws.chimesdkmeetings.model.Attendee.ReadOnly] = scala
      .Option(impl.attendee())
      .map(value => zio.aws.chimesdkmeetings.model.Attendee.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeResponse
  ): zio.aws.chimesdkmeetings.model.CreateAttendeeResponse.ReadOnly =
    new Wrapper(impl)
}
