package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MediaPipeline(
    mediaCapturePipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaCapturePipeline
    ] = Optional.Absent,
    mediaLiveConnectorPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaLiveConnectorPipeline
    ] = Optional.Absent,
    mediaConcatenationPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaConcatenationPipeline
    ] = Optional.Absent,
    mediaInsightsPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipeline
    ] = Optional.Absent,
    mediaStreamPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaStreamPipeline
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipeline = {
    import MediaPipeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipeline
      .builder()
      .optionallyWith(mediaCapturePipeline.map(value => value.buildAwsValue()))(
        _.mediaCapturePipeline
      )
      .optionallyWith(
        mediaLiveConnectorPipeline.map(value => value.buildAwsValue())
      )(_.mediaLiveConnectorPipeline)
      .optionallyWith(
        mediaConcatenationPipeline.map(value => value.buildAwsValue())
      )(_.mediaConcatenationPipeline)
      .optionallyWith(
        mediaInsightsPipeline.map(value => value.buildAwsValue())
      )(_.mediaInsightsPipeline)
      .optionallyWith(mediaStreamPipeline.map(value => value.buildAwsValue()))(
        _.mediaStreamPipeline
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmediapipelines.model.MediaPipeline.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.MediaPipeline.wrap(buildAwsValue())
}
object MediaPipeline {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipeline
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmediapipelines.model.MediaPipeline =
      zio.aws.chimesdkmediapipelines.model.MediaPipeline(
        mediaCapturePipeline.map(value => value.asEditable),
        mediaLiveConnectorPipeline.map(value => value.asEditable),
        mediaConcatenationPipeline.map(value => value.asEditable),
        mediaInsightsPipeline.map(value => value.asEditable),
        mediaStreamPipeline.map(value => value.asEditable)
      )
    def mediaCapturePipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaCapturePipeline.ReadOnly
    ]
    def mediaLiveConnectorPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaLiveConnectorPipeline.ReadOnly
    ]
    def mediaConcatenationPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaConcatenationPipeline.ReadOnly
    ]
    def mediaInsightsPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipeline.ReadOnly
    ]
    def mediaStreamPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaStreamPipeline.ReadOnly
    ]
    def getMediaCapturePipeline: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaCapturePipeline.ReadOnly
    ] = AwsError.unwrapOptionField("mediaCapturePipeline", mediaCapturePipeline)
    def getMediaLiveConnectorPipeline: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaLiveConnectorPipeline.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mediaLiveConnectorPipeline",
      mediaLiveConnectorPipeline
    )
    def getMediaConcatenationPipeline: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaConcatenationPipeline.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mediaConcatenationPipeline",
      mediaConcatenationPipeline
    )
    def getMediaInsightsPipeline: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipeline.ReadOnly
    ] =
      AwsError.unwrapOptionField("mediaInsightsPipeline", mediaInsightsPipeline)
    def getMediaStreamPipeline: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaStreamPipeline.ReadOnly
    ] = AwsError.unwrapOptionField("mediaStreamPipeline", mediaStreamPipeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipeline
  ) extends zio.aws.chimesdkmediapipelines.model.MediaPipeline.ReadOnly {
    override val mediaCapturePipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaCapturePipeline.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaCapturePipeline())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.MediaCapturePipeline.wrap(value)
      )
    override val mediaLiveConnectorPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaLiveConnectorPipeline.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaLiveConnectorPipeline())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.MediaLiveConnectorPipeline
          .wrap(value)
      )
    override val mediaConcatenationPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaConcatenationPipeline.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaConcatenationPipeline())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.MediaConcatenationPipeline
          .wrap(value)
      )
    override val mediaInsightsPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipeline.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaInsightsPipeline())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.MediaInsightsPipeline.wrap(value)
      )
    override val mediaStreamPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaStreamPipeline.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaStreamPipeline())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.MediaStreamPipeline.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipeline
  ): zio.aws.chimesdkmediapipelines.model.MediaPipeline.ReadOnly = new Wrapper(
    impl
  )
}
