package zio.aws.chimesdkmediapipelines.model
import scala.jdk.CollectionConverters.*
sealed trait MediaPipelineSinkType {
  def unwrap: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSinkType
}
object MediaPipelineSinkType {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSinkType
  ): zio.aws.chimesdkmediapipelines.model.MediaPipelineSinkType = value match {
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSinkType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSinkType.S3_BUCKET =>
      val r = S3Bucket
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineSinkType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSinkType =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSinkType.UNKNOWN_TO_SDK_VERSION
  }
  case object S3Bucket
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineSinkType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSinkType =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSinkType.S3_BUCKET
  }
}
