package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class LiveConnectorSinkConfiguration(
    sinkType: zio.aws.chimesdkmediapipelines.model.LiveConnectorSinkType,
    rtmpConfiguration: zio.aws.chimesdkmediapipelines.model.LiveConnectorRTMPConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSinkConfiguration = {
    import LiveConnectorSinkConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSinkConfiguration
      .builder()
      .sinkType(sinkType.unwrap)
      .rtmpConfiguration(rtmpConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.LiveConnectorSinkConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.LiveConnectorSinkConfiguration
      .wrap(buildAwsValue())
}
object LiveConnectorSinkConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSinkConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.LiveConnectorSinkConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .LiveConnectorSinkConfiguration(sinkType, rtmpConfiguration.asEditable)
    def sinkType: zio.aws.chimesdkmediapipelines.model.LiveConnectorSinkType
    def rtmpConfiguration
        : zio.aws.chimesdkmediapipelines.model.LiveConnectorRTMPConfiguration.ReadOnly
    def getSinkType: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.LiveConnectorSinkType
    ] = ZIO.succeed(sinkType)
    def getRtmpConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.LiveConnectorRTMPConfiguration.ReadOnly
    ] = ZIO.succeed(rtmpConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSinkConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.LiveConnectorSinkConfiguration.ReadOnly {
    override val sinkType
        : zio.aws.chimesdkmediapipelines.model.LiveConnectorSinkType =
      zio.aws.chimesdkmediapipelines.model.LiveConnectorSinkType
        .wrap(impl.sinkType())
    override val rtmpConfiguration
        : zio.aws.chimesdkmediapipelines.model.LiveConnectorRTMPConfiguration.ReadOnly =
      zio.aws.chimesdkmediapipelines.model.LiveConnectorRTMPConfiguration
        .wrap(impl.rtmpConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSinkConfiguration
  ): zio.aws.chimesdkmediapipelines.model.LiveConnectorSinkConfiguration.ReadOnly =
    new Wrapper(impl)
}
