package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.GuidString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetMediaPipelineRequest(mediaPipelineId: GuidString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineRequest = {
    import GetMediaPipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineRequest
      .builder()
      .mediaPipelineId(GuidString.unwrap(mediaPipelineId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.GetMediaPipelineRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.GetMediaPipelineRequest
      .wrap(buildAwsValue())
}
object GetMediaPipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.GetMediaPipelineRequest =
      zio.aws.chimesdkmediapipelines.model
        .GetMediaPipelineRequest(mediaPipelineId)
    def mediaPipelineId: GuidString
    def getMediaPipelineId: ZIO[Any, Nothing, GuidString] =
      ZIO.succeed(mediaPipelineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineRequest
  ) extends zio.aws.chimesdkmediapipelines.model.GetMediaPipelineRequest.ReadOnly {
    override val mediaPipelineId: GuidString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .GuidString(impl.mediaPipelineId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineRequest
  ): zio.aws.chimesdkmediapipelines.model.GetMediaPipelineRequest.ReadOnly =
    new Wrapper(impl)
}
