package zio.aws.chimesdkmediapipelines.model
import scala.jdk.CollectionConverters.*
sealed trait MediaStreamPipelineSinkType {
  def unwrap: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamPipelineSinkType
}
object MediaStreamPipelineSinkType {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamPipelineSinkType
  ): zio.aws.chimesdkmediapipelines.model.MediaStreamPipelineSinkType =
    value match {
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamPipelineSinkType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamPipelineSinkType.KINESIS_VIDEO_STREAM_POOL =>
        val r = KinesisVideoStreamPool
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmediapipelines.model.MediaStreamPipelineSinkType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamPipelineSinkType =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamPipelineSinkType.UNKNOWN_TO_SDK_VERSION
  }
  case object KinesisVideoStreamPool
      extends zio.aws.chimesdkmediapipelines.model.MediaStreamPipelineSinkType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamPipelineSinkType =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamPipelineSinkType.KINESIS_VIDEO_STREAM_POOL
  }
}
