package zio.aws.chimesdkmediapipelines.model
import java.lang.Integer
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.MediaSampleRateHertz
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KinesisVideoStreamSourceRuntimeConfiguration(
    streams: Iterable[zio.aws.chimesdkmediapipelines.model.StreamConfiguration],
    mediaEncoding: zio.aws.chimesdkmediapipelines.model.MediaEncoding,
    mediaSampleRate: MediaSampleRateHertz
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration = {
    import KinesisVideoStreamSourceRuntimeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration
      .builder()
      .streams(streams.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .mediaEncoding(mediaEncoding.unwrap)
      .mediaSampleRate(MediaSampleRateHertz.unwrap(mediaSampleRate): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration
      .wrap(buildAwsValue())
}
object KinesisVideoStreamSourceRuntimeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .KinesisVideoStreamSourceRuntimeConfiguration(
          streams.map { item =>
            item.asEditable
          },
          mediaEncoding,
          mediaSampleRate
        )
    def streams: List[
      zio.aws.chimesdkmediapipelines.model.StreamConfiguration.ReadOnly
    ]
    def mediaEncoding: zio.aws.chimesdkmediapipelines.model.MediaEncoding
    def mediaSampleRate: MediaSampleRateHertz
    def getStreams: ZIO[Any, Nothing, List[
      zio.aws.chimesdkmediapipelines.model.StreamConfiguration.ReadOnly
    ]] = ZIO.succeed(streams)
    def getMediaEncoding: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.MediaEncoding
    ] = ZIO.succeed(mediaEncoding)
    def getMediaSampleRate: ZIO[Any, Nothing, MediaSampleRateHertz] =
      ZIO.succeed(mediaSampleRate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration.ReadOnly {
    override val streams: List[
      zio.aws.chimesdkmediapipelines.model.StreamConfiguration.ReadOnly
    ] = impl
      .streams()
      .asScala
      .map { item =>
        zio.aws.chimesdkmediapipelines.model.StreamConfiguration.wrap(item)
      }
      .toList
    override val mediaEncoding
        : zio.aws.chimesdkmediapipelines.model.MediaEncoding =
      zio.aws.chimesdkmediapipelines.model.MediaEncoding
        .wrap(impl.mediaEncoding())
    override val mediaSampleRate: MediaSampleRateHertz =
      zio.aws.chimesdkmediapipelines.model.primitives
        .MediaSampleRateHertz(impl.mediaSampleRate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration
  ): zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration.ReadOnly =
    new Wrapper(impl)
}
