package zio.aws.chimesdkmediapipelines.model
import scala.jdk.CollectionConverters.*
sealed trait ConcatenationSourceType {
  def unwrap: software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSourceType
}
object ConcatenationSourceType {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSourceType
  ): zio.aws.chimesdkmediapipelines.model.ConcatenationSourceType =
    value match {
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSourceType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSourceType.MEDIA_CAPTURE_PIPELINE =>
        val r = MediaCapturePipeline
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmediapipelines.model.ConcatenationSourceType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSourceType =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object MediaCapturePipeline
      extends zio.aws.chimesdkmediapipelines.model.ConcatenationSourceType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSourceType =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSourceType.MEDIA_CAPTURE_PIPELINE
  }
}
