package zio.aws.chimesdkmediapipelines.model
import java.lang.Integer
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{
  SentimentTimePeriodInSeconds,
  RuleName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SentimentConfiguration(
    ruleName: RuleName,
    sentimentType: zio.aws.chimesdkmediapipelines.model.SentimentType,
    timePeriod: SentimentTimePeriodInSeconds
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.SentimentConfiguration = {
    import SentimentConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.SentimentConfiguration
      .builder()
      .ruleName(RuleName.unwrap(ruleName): java.lang.String)
      .sentimentType(sentimentType.unwrap)
      .timePeriod(SentimentTimePeriodInSeconds.unwrap(timePeriod): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.SentimentConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.SentimentConfiguration
      .wrap(buildAwsValue())
}
object SentimentConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.SentimentConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.SentimentConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .SentimentConfiguration(ruleName, sentimentType, timePeriod)
    def ruleName: RuleName
    def sentimentType: zio.aws.chimesdkmediapipelines.model.SentimentType
    def timePeriod: SentimentTimePeriodInSeconds
    def getRuleName: ZIO[Any, Nothing, RuleName] = ZIO.succeed(ruleName)
    def getSentimentType: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.SentimentType
    ] = ZIO.succeed(sentimentType)
    def getTimePeriod: ZIO[Any, Nothing, SentimentTimePeriodInSeconds] =
      ZIO.succeed(timePeriod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.SentimentConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.SentimentConfiguration.ReadOnly {
    override val ruleName: RuleName =
      zio.aws.chimesdkmediapipelines.model.primitives.RuleName(impl.ruleName())
    override val sentimentType
        : zio.aws.chimesdkmediapipelines.model.SentimentType =
      zio.aws.chimesdkmediapipelines.model.SentimentType
        .wrap(impl.sentimentType())
    override val timePeriod: SentimentTimePeriodInSeconds =
      zio.aws.chimesdkmediapipelines.model.primitives
        .SentimentTimePeriodInSeconds(impl.timePeriod())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.SentimentConfiguration
  ): zio.aws.chimesdkmediapipelines.model.SentimentConfiguration.ReadOnly =
    new Wrapper(impl)
}
