package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RealTimeAlertConfiguration(
    disabled: Optional[Boolean] = Optional.Absent,
    rules: Optional[
      Iterable[zio.aws.chimesdkmediapipelines.model.RealTimeAlertRule]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.RealTimeAlertConfiguration = {
    import RealTimeAlertConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.RealTimeAlertConfiguration
      .builder()
      .optionallyWith(disabled.map(value => value: java.lang.Boolean))(
        _.disabled
      )
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration
      .wrap(buildAwsValue())
}
object RealTimeAlertConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.RealTimeAlertConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration =
      zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration(
        disabled.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def disabled: Optional[Boolean]
    def rules: Optional[
      List[zio.aws.chimesdkmediapipelines.model.RealTimeAlertRule.ReadOnly]
    ]
    def getDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disabled", disabled)
    def getRules: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmediapipelines.model.RealTimeAlertRule.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.RealTimeAlertConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration.ReadOnly {
    override val disabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disabled())
      .map(value => value: Boolean)
    override val rules: Optional[
      List[zio.aws.chimesdkmediapipelines.model.RealTimeAlertRule.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmediapipelines.model.RealTimeAlertRule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.RealTimeAlertConfiguration
  ): zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration.ReadOnly =
    new Wrapper(impl)
}
