package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateMediaStreamPipelineResponse(
    mediaStreamPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaStreamPipeline
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaStreamPipelineResponse = {
    import CreateMediaStreamPipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaStreamPipelineResponse
      .builder()
      .optionallyWith(mediaStreamPipeline.map(value => value.buildAwsValue()))(
        _.mediaStreamPipeline
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.CreateMediaStreamPipelineResponse.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.CreateMediaStreamPipelineResponse
      .wrap(buildAwsValue())
}
object CreateMediaStreamPipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaStreamPipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.CreateMediaStreamPipelineResponse =
      zio.aws.chimesdkmediapipelines.model.CreateMediaStreamPipelineResponse(
        mediaStreamPipeline.map(value => value.asEditable)
      )
    def mediaStreamPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaStreamPipeline.ReadOnly
    ]
    def getMediaStreamPipeline: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaStreamPipeline.ReadOnly
    ] = AwsError.unwrapOptionField("mediaStreamPipeline", mediaStreamPipeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaStreamPipelineResponse
  ) extends zio.aws.chimesdkmediapipelines.model.CreateMediaStreamPipelineResponse.ReadOnly {
    override val mediaStreamPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaStreamPipeline.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaStreamPipeline())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.MediaStreamPipeline.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaStreamPipelineResponse
  ): zio.aws.chimesdkmediapipelines.model.CreateMediaStreamPipelineResponse.ReadOnly =
    new Wrapper(impl)
}
