package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.KinesisVideoStreamArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RecordingStreamConfiguration(
    streamArn: Optional[KinesisVideoStreamArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingStreamConfiguration = {
    import RecordingStreamConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingStreamConfiguration
      .builder()
      .optionallyWith(
        streamArn.map(value =>
          KinesisVideoStreamArn.unwrap(value): java.lang.String
        )
      )(_.streamArn)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.RecordingStreamConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.RecordingStreamConfiguration
      .wrap(buildAwsValue())
}
object RecordingStreamConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingStreamConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.RecordingStreamConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .RecordingStreamConfiguration(streamArn.map(value => value))
    def streamArn: Optional[KinesisVideoStreamArn]
    def getStreamArn: ZIO[Any, AwsError, KinesisVideoStreamArn] =
      AwsError.unwrapOptionField("streamArn", streamArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingStreamConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.RecordingStreamConfiguration.ReadOnly {
    override val streamArn: Optional[KinesisVideoStreamArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamArn())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .KinesisVideoStreamArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingStreamConfiguration
  ): zio.aws.chimesdkmediapipelines.model.RecordingStreamConfiguration.ReadOnly =
    new Wrapper(impl)
}
