package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PresenterOnlyConfiguration(
    presenterPosition: Optional[
      zio.aws.chimesdkmediapipelines.model.PresenterPosition
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.PresenterOnlyConfiguration = {
    import PresenterOnlyConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.PresenterOnlyConfiguration
      .builder()
      .optionallyWith(presenterPosition.map(value => value.unwrap))(
        _.presenterPosition
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.PresenterOnlyConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.PresenterOnlyConfiguration
      .wrap(buildAwsValue())
}
object PresenterOnlyConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.PresenterOnlyConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.PresenterOnlyConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .PresenterOnlyConfiguration(presenterPosition.map(value => value))
    def presenterPosition
        : Optional[zio.aws.chimesdkmediapipelines.model.PresenterPosition]
    def getPresenterPosition: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.PresenterPosition
    ] = AwsError.unwrapOptionField("presenterPosition", presenterPosition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.PresenterOnlyConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.PresenterOnlyConfiguration.ReadOnly {
    override val presenterPosition
        : Optional[zio.aws.chimesdkmediapipelines.model.PresenterPosition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.presenterPosition())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.PresenterPosition.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.PresenterOnlyConfiguration
  ): zio.aws.chimesdkmediapipelines.model.PresenterOnlyConfiguration.ReadOnly =
    new Wrapper(impl)
}
