package zio.aws.chimesdkmediapipelines.model
import scala.jdk.CollectionConverters.*
sealed trait MediaPipelineElementStatus {
  def unwrap: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus
}
object MediaPipelineElementStatus {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus
  ): zio.aws.chimesdkmediapipelines.model.MediaPipelineElementStatus =
    value match {
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus.NOT_STARTED =>
        val r = NotStarted
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus.NOT_SUPPORTED =>
        val r = NotSupported
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus.INITIALIZING =>
        val r = Initializing
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus.IN_PROGRESS =>
        val r = InProgress
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus.FAILED =>
        val r = Failed
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus.STOPPING =>
        val r = Stopping
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus.STOPPED =>
        val r = Stopped
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus.PAUSED =>
        val r = Paused
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineElementStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NotStarted
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineElementStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus.NOT_STARTED
  }
  case object NotSupported
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineElementStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus.NOT_SUPPORTED
  }
  case object Initializing
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineElementStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus.INITIALIZING
  }
  case object InProgress
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineElementStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus.IN_PROGRESS
  }
  case object Failed
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineElementStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus.FAILED
  }
  case object Stopping
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineElementStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus.STOPPING
  }
  case object Stopped
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineElementStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus.STOPPED
  }
  case object Paused
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineElementStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineElementStatus.PAUSED
  }
}
