package zio.aws.chimesdkmediapipelines.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmediapipelines.model.primitives.{
  TileAspectRatio,
  TileCount
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class HorizontalLayoutConfiguration(
    tileOrder: Optional[zio.aws.chimesdkmediapipelines.model.TileOrder] =
      Optional.Absent,
    tilePosition: Optional[
      zio.aws.chimesdkmediapipelines.model.HorizontalTilePosition
    ] = Optional.Absent,
    tileCount: Optional[TileCount] = Optional.Absent,
    tileAspectRatio: Optional[TileAspectRatio] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.HorizontalLayoutConfiguration = {
    import HorizontalLayoutConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.HorizontalLayoutConfiguration
      .builder()
      .optionallyWith(tileOrder.map(value => value.unwrap))(_.tileOrder)
      .optionallyWith(tilePosition.map(value => value.unwrap))(_.tilePosition)
      .optionallyWith(tileCount.map(value => TileCount.unwrap(value): Integer))(
        _.tileCount
      )
      .optionallyWith(
        tileAspectRatio.map(value =>
          TileAspectRatio.unwrap(value): java.lang.String
        )
      )(_.tileAspectRatio)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.HorizontalLayoutConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.HorizontalLayoutConfiguration
      .wrap(buildAwsValue())
}
object HorizontalLayoutConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.HorizontalLayoutConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.HorizontalLayoutConfiguration =
      zio.aws.chimesdkmediapipelines.model.HorizontalLayoutConfiguration(
        tileOrder.map(value => value),
        tilePosition.map(value => value),
        tileCount.map(value => value),
        tileAspectRatio.map(value => value)
      )
    def tileOrder: Optional[zio.aws.chimesdkmediapipelines.model.TileOrder]
    def tilePosition
        : Optional[zio.aws.chimesdkmediapipelines.model.HorizontalTilePosition]
    def tileCount: Optional[TileCount]
    def tileAspectRatio: Optional[TileAspectRatio]
    def getTileOrder
        : ZIO[Any, AwsError, zio.aws.chimesdkmediapipelines.model.TileOrder] =
      AwsError.unwrapOptionField("tileOrder", tileOrder)
    def getTilePosition: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.HorizontalTilePosition
    ] = AwsError.unwrapOptionField("tilePosition", tilePosition)
    def getTileCount: ZIO[Any, AwsError, TileCount] =
      AwsError.unwrapOptionField("tileCount", tileCount)
    def getTileAspectRatio: ZIO[Any, AwsError, TileAspectRatio] =
      AwsError.unwrapOptionField("tileAspectRatio", tileAspectRatio)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.HorizontalLayoutConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.HorizontalLayoutConfiguration.ReadOnly {
    override val tileOrder
        : Optional[zio.aws.chimesdkmediapipelines.model.TileOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tileOrder())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.TileOrder.wrap(value)
        )
    override val tilePosition: Optional[
      zio.aws.chimesdkmediapipelines.model.HorizontalTilePosition
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tilePosition())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.HorizontalTilePosition.wrap(value)
      )
    override val tileCount: Optional[TileCount] = zio.aws.core.internal
      .optionalFromNullable(impl.tileCount())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.primitives.TileCount(value)
      )
    override val tileAspectRatio: Optional[TileAspectRatio] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tileAspectRatio())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives.TileAspectRatio(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.HorizontalLayoutConfiguration
  ): zio.aws.chimesdkmediapipelines.model.HorizontalLayoutConfiguration.ReadOnly =
    new Wrapper(impl)
}
