package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetVoiceToneAnalysisTaskResponse(
    voiceToneAnalysisTask: Optional[
      zio.aws.chimesdkmediapipelines.model.VoiceToneAnalysisTask
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskResponse = {
    import GetVoiceToneAnalysisTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskResponse
      .builder()
      .optionallyWith(
        voiceToneAnalysisTask.map(value => value.buildAwsValue())
      )(_.voiceToneAnalysisTask)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskResponse.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskResponse
      .wrap(buildAwsValue())
}
object GetVoiceToneAnalysisTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskResponse =
      zio.aws.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskResponse(
        voiceToneAnalysisTask.map(value => value.asEditable)
      )
    def voiceToneAnalysisTask: Optional[
      zio.aws.chimesdkmediapipelines.model.VoiceToneAnalysisTask.ReadOnly
    ]
    def getVoiceToneAnalysisTask: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.VoiceToneAnalysisTask.ReadOnly
    ] =
      AwsError.unwrapOptionField("voiceToneAnalysisTask", voiceToneAnalysisTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskResponse
  ) extends zio.aws.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskResponse.ReadOnly {
    override val voiceToneAnalysisTask: Optional[
      zio.aws.chimesdkmediapipelines.model.VoiceToneAnalysisTask.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.voiceToneAnalysisTask())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.VoiceToneAnalysisTask.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskResponse
  ): zio.aws.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskResponse.ReadOnly =
    new Wrapper(impl)
}
