package zio.aws.chimesdkmediapipelines.model
import scala.jdk.CollectionConverters.*
sealed trait TileOrder {
  def unwrap
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.TileOrder
}
object TileOrder {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmediapipelines.model.TileOrder
  ): zio.aws.chimesdkmediapipelines.model.TileOrder = value match {
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.TileOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.TileOrder.JOIN_SEQUENCE =>
      val r = JoinSequence
      r
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.TileOrder.SPEAKER_SEQUENCE =>
      val r = SpeakerSequence
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmediapipelines.model.TileOrder {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.TileOrder =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.TileOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object JoinSequence
      extends zio.aws.chimesdkmediapipelines.model.TileOrder {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.TileOrder =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.TileOrder.JOIN_SEQUENCE
  }
  case object SpeakerSequence
      extends zio.aws.chimesdkmediapipelines.model.TileOrder {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.TileOrder =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.TileOrder.SPEAKER_SEQUENCE
  }
}
