package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{
  GuidString,
  NonEmptyString
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StopVoiceToneAnalysisTaskRequest(
    identifier: NonEmptyString,
    voiceToneAnalysisTaskId: GuidString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.StopVoiceToneAnalysisTaskRequest = {
    import StopVoiceToneAnalysisTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.StopVoiceToneAnalysisTaskRequest
      .builder()
      .identifier(NonEmptyString.unwrap(identifier): java.lang.String)
      .voiceToneAnalysisTaskId(
        GuidString.unwrap(voiceToneAnalysisTaskId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.StopVoiceToneAnalysisTaskRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.StopVoiceToneAnalysisTaskRequest
      .wrap(buildAwsValue())
}
object StopVoiceToneAnalysisTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.StopVoiceToneAnalysisTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.StopVoiceToneAnalysisTaskRequest =
      zio.aws.chimesdkmediapipelines.model
        .StopVoiceToneAnalysisTaskRequest(identifier, voiceToneAnalysisTaskId)
    def identifier: NonEmptyString
    def voiceToneAnalysisTaskId: GuidString
    def getIdentifier: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(identifier)
    def getVoiceToneAnalysisTaskId: ZIO[Any, Nothing, GuidString] =
      ZIO.succeed(voiceToneAnalysisTaskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.StopVoiceToneAnalysisTaskRequest
  ) extends zio.aws.chimesdkmediapipelines.model.StopVoiceToneAnalysisTaskRequest.ReadOnly {
    override val identifier: NonEmptyString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .NonEmptyString(impl.identifier())
    override val voiceToneAnalysisTaskId: GuidString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .GuidString(impl.voiceToneAnalysisTaskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.StopVoiceToneAnalysisTaskRequest
  ): zio.aws.chimesdkmediapipelines.model.StopVoiceToneAnalysisTaskRequest.ReadOnly =
    new Wrapper(impl)
}
