package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{
  GuidString,
  NonEmptyString
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StopSpeakerSearchTaskRequest(
    identifier: NonEmptyString,
    speakerSearchTaskId: GuidString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.StopSpeakerSearchTaskRequest = {
    import StopSpeakerSearchTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.StopSpeakerSearchTaskRequest
      .builder()
      .identifier(NonEmptyString.unwrap(identifier): java.lang.String)
      .speakerSearchTaskId(
        GuidString.unwrap(speakerSearchTaskId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.StopSpeakerSearchTaskRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.StopSpeakerSearchTaskRequest
      .wrap(buildAwsValue())
}
object StopSpeakerSearchTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.StopSpeakerSearchTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.StopSpeakerSearchTaskRequest =
      zio.aws.chimesdkmediapipelines.model
        .StopSpeakerSearchTaskRequest(identifier, speakerSearchTaskId)
    def identifier: NonEmptyString
    def speakerSearchTaskId: GuidString
    def getIdentifier: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(identifier)
    def getSpeakerSearchTaskId: ZIO[Any, Nothing, GuidString] =
      ZIO.succeed(speakerSearchTaskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.StopSpeakerSearchTaskRequest
  ) extends zio.aws.chimesdkmediapipelines.model.StopSpeakerSearchTaskRequest.ReadOnly {
    override val identifier: NonEmptyString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .NonEmptyString(impl.identifier())
    override val speakerSearchTaskId: GuidString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .GuidString(impl.speakerSearchTaskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.StopSpeakerSearchTaskRequest
  ): zio.aws.chimesdkmediapipelines.model.StopSpeakerSearchTaskRequest.ReadOnly =
    new Wrapper(impl)
}
