package zio.aws.chimesdkmediapipelines.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmediapipelines.model.primitives.{
  Iso8601Timestamp,
  GuidString
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class SpeakerSearchTask(
    speakerSearchTaskId: Optional[GuidString] = Optional.Absent,
    speakerSearchTaskStatus: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaPipelineTaskStatus
    ] = Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.SpeakerSearchTask = {
    import SpeakerSearchTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.SpeakerSearchTask
      .builder()
      .optionallyWith(
        speakerSearchTaskId.map(value =>
          GuidString.unwrap(value): java.lang.String
        )
      )(_.speakerSearchTaskId)
      .optionallyWith(speakerSearchTaskStatus.map(value => value.unwrap))(
        _.speakerSearchTaskStatus
      )
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.SpeakerSearchTask.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.SpeakerSearchTask.wrap(buildAwsValue())
}
object SpeakerSearchTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.SpeakerSearchTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmediapipelines.model.SpeakerSearchTask =
      zio.aws.chimesdkmediapipelines.model.SpeakerSearchTask(
        speakerSearchTaskId.map(value => value),
        speakerSearchTaskStatus.map(value => value),
        createdTimestamp.map(value => value),
        updatedTimestamp.map(value => value)
      )
    def speakerSearchTaskId: Optional[GuidString]
    def speakerSearchTaskStatus
        : Optional[zio.aws.chimesdkmediapipelines.model.MediaPipelineTaskStatus]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def getSpeakerSearchTaskId: ZIO[Any, AwsError, GuidString] =
      AwsError.unwrapOptionField("speakerSearchTaskId", speakerSearchTaskId)
    def getSpeakerSearchTaskStatus: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaPipelineTaskStatus
    ] = AwsError.unwrapOptionField(
      "speakerSearchTaskStatus",
      speakerSearchTaskStatus
    )
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.SpeakerSearchTask
  ) extends zio.aws.chimesdkmediapipelines.model.SpeakerSearchTask.ReadOnly {
    override val speakerSearchTaskId: Optional[GuidString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.speakerSearchTaskId())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives.GuidString(value)
        )
    override val speakerSearchTaskStatus: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaPipelineTaskStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.speakerSearchTaskStatus())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.MediaPipelineTaskStatus.wrap(value)
      )
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .Iso8601Timestamp(value)
        )
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .Iso8601Timestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.SpeakerSearchTask
  ): zio.aws.chimesdkmediapipelines.model.SpeakerSearchTask.ReadOnly =
    new Wrapper(impl)
}
