package zio.aws.chimesdkmediapipelines.model
import java.lang.Integer
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{
  ReservedStreamCapacity,
  Arn
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MediaStreamSink(
    sinkArn: Arn,
    sinkType: zio.aws.chimesdkmediapipelines.model.MediaStreamPipelineSinkType,
    reservedStreamCapacity: ReservedStreamCapacity,
    mediaStreamType: zio.aws.chimesdkmediapipelines.model.MediaStreamType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSink = {
    import MediaStreamSink.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSink
      .builder()
      .sinkArn(Arn.unwrap(sinkArn): java.lang.String)
      .sinkType(sinkType.unwrap)
      .reservedStreamCapacity(
        ReservedStreamCapacity.unwrap(reservedStreamCapacity): Integer
      )
      .mediaStreamType(mediaStreamType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.MediaStreamSink.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.MediaStreamSink.wrap(buildAwsValue())
}
object MediaStreamSink {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSink
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmediapipelines.model.MediaStreamSink =
      zio.aws.chimesdkmediapipelines.model.MediaStreamSink(
        sinkArn,
        sinkType,
        reservedStreamCapacity,
        mediaStreamType
      )
    def sinkArn: Arn
    def sinkType
        : zio.aws.chimesdkmediapipelines.model.MediaStreamPipelineSinkType
    def reservedStreamCapacity: ReservedStreamCapacity
    def mediaStreamType: zio.aws.chimesdkmediapipelines.model.MediaStreamType
    def getSinkArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(sinkArn)
    def getSinkType: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.MediaStreamPipelineSinkType
    ] = ZIO.succeed(sinkType)
    def getReservedStreamCapacity: ZIO[Any, Nothing, ReservedStreamCapacity] =
      ZIO.succeed(reservedStreamCapacity)
    def getMediaStreamType: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.MediaStreamType
    ] = ZIO.succeed(mediaStreamType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSink
  ) extends zio.aws.chimesdkmediapipelines.model.MediaStreamSink.ReadOnly {
    override val sinkArn: Arn =
      zio.aws.chimesdkmediapipelines.model.primitives.Arn(impl.sinkArn())
    override val sinkType
        : zio.aws.chimesdkmediapipelines.model.MediaStreamPipelineSinkType =
      zio.aws.chimesdkmediapipelines.model.MediaStreamPipelineSinkType
        .wrap(impl.sinkType())
    override val reservedStreamCapacity: ReservedStreamCapacity =
      zio.aws.chimesdkmediapipelines.model.primitives
        .ReservedStreamCapacity(impl.reservedStreamCapacity())
    override val mediaStreamType
        : zio.aws.chimesdkmediapipelines.model.MediaStreamType =
      zio.aws.chimesdkmediapipelines.model.MediaStreamType
        .wrap(impl.mediaStreamType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSink
  ): zio.aws.chimesdkmediapipelines.model.MediaStreamSink.ReadOnly =
    new Wrapper(impl)
}
