package zio.aws.chimesdkmediapipelines.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmediapipelines.model.primitives.{
  Iso8601Timestamp,
  AmazonResourceName,
  GuidString
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class MediaStreamPipeline(
    mediaPipelineId: Optional[GuidString] = Optional.Absent,
    mediaPipelineArn: Optional[AmazonResourceName] = Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    status: Optional[zio.aws.chimesdkmediapipelines.model.MediaPipelineStatus] =
      Optional.Absent,
    sources: Optional[
      Iterable[zio.aws.chimesdkmediapipelines.model.MediaStreamSource]
    ] = Optional.Absent,
    sinks: Optional[
      Iterable[zio.aws.chimesdkmediapipelines.model.MediaStreamSink]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamPipeline = {
    import MediaStreamPipeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamPipeline
      .builder()
      .optionallyWith(
        mediaPipelineId.map(value => GuidString.unwrap(value): java.lang.String)
      )(_.mediaPipelineId)
      .optionallyWith(
        mediaPipelineArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.mediaPipelineArn)
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .optionallyWith(
        sinks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sinks)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.MediaStreamPipeline.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.MediaStreamPipeline
      .wrap(buildAwsValue())
}
object MediaStreamPipeline {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamPipeline
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmediapipelines.model.MediaStreamPipeline =
      zio.aws.chimesdkmediapipelines.model.MediaStreamPipeline(
        mediaPipelineId.map(value => value),
        mediaPipelineArn.map(value => value),
        createdTimestamp.map(value => value),
        updatedTimestamp.map(value => value),
        status.map(value => value),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sinks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def mediaPipelineId: Optional[GuidString]
    def mediaPipelineArn: Optional[AmazonResourceName]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def status
        : Optional[zio.aws.chimesdkmediapipelines.model.MediaPipelineStatus]
    def sources: Optional[
      List[zio.aws.chimesdkmediapipelines.model.MediaStreamSource.ReadOnly]
    ]
    def sinks: Optional[
      List[zio.aws.chimesdkmediapipelines.model.MediaStreamSink.ReadOnly]
    ]
    def getMediaPipelineId: ZIO[Any, AwsError, GuidString] =
      AwsError.unwrapOptionField("mediaPipelineId", mediaPipelineId)
    def getMediaPipelineArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("mediaPipelineArn", mediaPipelineArn)
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaPipelineStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmediapipelines.model.MediaStreamSource.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
    def getSinks: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmediapipelines.model.MediaStreamSink.ReadOnly
    ]] = AwsError.unwrapOptionField("sinks", sinks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamPipeline
  ) extends zio.aws.chimesdkmediapipelines.model.MediaStreamPipeline.ReadOnly {
    override val mediaPipelineId: Optional[GuidString] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaPipelineId())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.primitives.GuidString(value)
      )
    override val mediaPipelineArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaPipelineArn())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .AmazonResourceName(value)
        )
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .Iso8601Timestamp(value)
        )
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .Iso8601Timestamp(value)
        )
    override val status
        : Optional[zio.aws.chimesdkmediapipelines.model.MediaPipelineStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.MediaPipelineStatus.wrap(value)
        )
    override val sources: Optional[
      List[zio.aws.chimesdkmediapipelines.model.MediaStreamSource.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmediapipelines.model.MediaStreamSource.wrap(item)
        }.toList
      )
    override val sinks: Optional[
      List[zio.aws.chimesdkmediapipelines.model.MediaStreamSink.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sinks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmediapipelines.model.MediaStreamSink.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamPipeline
  ): zio.aws.chimesdkmediapipelines.model.MediaStreamPipeline.ReadOnly =
    new Wrapper(impl)
}
