package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{
  GuidString,
  NonEmptyString
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetVoiceToneAnalysisTaskRequest(
    identifier: NonEmptyString,
    voiceToneAnalysisTaskId: GuidString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskRequest = {
    import GetVoiceToneAnalysisTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskRequest
      .builder()
      .identifier(NonEmptyString.unwrap(identifier): java.lang.String)
      .voiceToneAnalysisTaskId(
        GuidString.unwrap(voiceToneAnalysisTaskId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskRequest
      .wrap(buildAwsValue())
}
object GetVoiceToneAnalysisTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskRequest =
      zio.aws.chimesdkmediapipelines.model
        .GetVoiceToneAnalysisTaskRequest(identifier, voiceToneAnalysisTaskId)
    def identifier: NonEmptyString
    def voiceToneAnalysisTaskId: GuidString
    def getIdentifier: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(identifier)
    def getVoiceToneAnalysisTaskId: ZIO[Any, Nothing, GuidString] =
      ZIO.succeed(voiceToneAnalysisTaskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskRequest
  ) extends zio.aws.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskRequest.ReadOnly {
    override val identifier: NonEmptyString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .NonEmptyString(impl.identifier())
    override val voiceToneAnalysisTaskId: GuidString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .GuidString(impl.voiceToneAnalysisTaskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskRequest
  ): zio.aws.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskRequest.ReadOnly =
    new Wrapper(impl)
}
