package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{
  ClientRequestToken,
  KinesisVideoStreamPoolName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateMediaPipelineKinesisVideoStreamPoolRequest(
    streamConfiguration: zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration,
    poolName: KinesisVideoStreamPoolName,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.chimesdkmediapipelines.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaPipelineKinesisVideoStreamPoolRequest = {
    import CreateMediaPipelineKinesisVideoStreamPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaPipelineKinesisVideoStreamPoolRequest
      .builder()
      .streamConfiguration(streamConfiguration.buildAwsValue())
      .poolName(KinesisVideoStreamPoolName.unwrap(poolName): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.CreateMediaPipelineKinesisVideoStreamPoolRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.CreateMediaPipelineKinesisVideoStreamPoolRequest
      .wrap(buildAwsValue())
}
object CreateMediaPipelineKinesisVideoStreamPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaPipelineKinesisVideoStreamPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.CreateMediaPipelineKinesisVideoStreamPoolRequest =
      zio.aws.chimesdkmediapipelines.model
        .CreateMediaPipelineKinesisVideoStreamPoolRequest(
          streamConfiguration.asEditable,
          poolName,
          clientRequestToken.map(value => value),
          tags.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def streamConfiguration
        : zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration.ReadOnly
    def poolName: KinesisVideoStreamPoolName
    def clientRequestToken: Optional[ClientRequestToken]
    def tags: Optional[List[zio.aws.chimesdkmediapipelines.model.Tag.ReadOnly]]
    def getStreamConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration.ReadOnly
    ] = ZIO.succeed(streamConfiguration)
    def getPoolName: ZIO[Any, Nothing, KinesisVideoStreamPoolName] =
      ZIO.succeed(poolName)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmediapipelines.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaPipelineKinesisVideoStreamPoolRequest
  ) extends zio.aws.chimesdkmediapipelines.model.CreateMediaPipelineKinesisVideoStreamPoolRequest.ReadOnly {
    override val streamConfiguration
        : zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration.ReadOnly =
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration
        .wrap(impl.streamConfiguration())
    override val poolName: KinesisVideoStreamPoolName =
      zio.aws.chimesdkmediapipelines.model.primitives
        .KinesisVideoStreamPoolName(impl.poolName())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .ClientRequestToken(value)
        )
    override val tags
        : Optional[List[zio.aws.chimesdkmediapipelines.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkmediapipelines.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaPipelineKinesisVideoStreamPoolRequest
  ): zio.aws.chimesdkmediapipelines.model.CreateMediaPipelineKinesisVideoStreamPoolRequest.ReadOnly =
    new Wrapper(impl)
}
