package zio.aws.chimesdkmediapipelines.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmediapipelines.model.primitives.ChannelId
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ChannelDefinition(
    channelId: ChannelId,
    participantRole: Optional[
      zio.aws.chimesdkmediapipelines.model.ParticipantRole
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.ChannelDefinition = {
    import ChannelDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ChannelDefinition
      .builder()
      .channelId(ChannelId.unwrap(channelId): Integer)
      .optionallyWith(participantRole.map(value => value.unwrap))(
        _.participantRole
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.ChannelDefinition.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.ChannelDefinition.wrap(buildAwsValue())
}
object ChannelDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ChannelDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmediapipelines.model.ChannelDefinition =
      zio.aws.chimesdkmediapipelines.model
        .ChannelDefinition(channelId, participantRole.map(value => value))
    def channelId: ChannelId
    def participantRole
        : Optional[zio.aws.chimesdkmediapipelines.model.ParticipantRole]
    def getChannelId: ZIO[Any, Nothing, ChannelId] = ZIO.succeed(channelId)
    def getParticipantRole: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.ParticipantRole
    ] = AwsError.unwrapOptionField("participantRole", participantRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ChannelDefinition
  ) extends zio.aws.chimesdkmediapipelines.model.ChannelDefinition.ReadOnly {
    override val channelId: ChannelId =
      zio.aws.chimesdkmediapipelines.model.primitives
        .ChannelId(impl.channelId())
    override val participantRole
        : Optional[zio.aws.chimesdkmediapipelines.model.ParticipantRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.participantRole())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.ParticipantRole.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ChannelDefinition
  ): zio.aws.chimesdkmediapipelines.model.ChannelDefinition.ReadOnly =
    new Wrapper(impl)
}
