package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ContentArtifactsConfiguration(
    state: zio.aws.chimesdkmediapipelines.model.ArtifactsState,
    muxType: Optional[zio.aws.chimesdkmediapipelines.model.ContentMuxType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.ContentArtifactsConfiguration = {
    import ContentArtifactsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ContentArtifactsConfiguration
      .builder()
      .state(state.unwrap)
      .optionallyWith(muxType.map(value => value.unwrap))(_.muxType)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.ContentArtifactsConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.ContentArtifactsConfiguration
      .wrap(buildAwsValue())
}
object ContentArtifactsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ContentArtifactsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.ContentArtifactsConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .ContentArtifactsConfiguration(state, muxType.map(value => value))
    def state: zio.aws.chimesdkmediapipelines.model.ArtifactsState
    def muxType: Optional[zio.aws.chimesdkmediapipelines.model.ContentMuxType]
    def getState: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.ArtifactsState
    ] = ZIO.succeed(state)
    def getMuxType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.ContentMuxType
    ] = AwsError.unwrapOptionField("muxType", muxType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ContentArtifactsConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.ContentArtifactsConfiguration.ReadOnly {
    override val state: zio.aws.chimesdkmediapipelines.model.ArtifactsState =
      zio.aws.chimesdkmediapipelines.model.ArtifactsState.wrap(impl.state())
    override val muxType
        : Optional[zio.aws.chimesdkmediapipelines.model.ContentMuxType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.muxType())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.ContentMuxType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ContentArtifactsConfiguration
  ): zio.aws.chimesdkmediapipelines.model.ContentArtifactsConfiguration.ReadOnly =
    new Wrapper(impl)
}
