package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateMediaInsightsPipelineConfigurationResponse(
    mediaInsightsPipelineConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationResponse = {
    import UpdateMediaInsightsPipelineConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationResponse
      .builder()
      .optionallyWith(
        mediaInsightsPipelineConfiguration.map(value => value.buildAwsValue())
      )(_.mediaInsightsPipelineConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationResponse.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationResponse
      .wrap(buildAwsValue())
}
object UpdateMediaInsightsPipelineConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationResponse =
      zio.aws.chimesdkmediapipelines.model
        .UpdateMediaInsightsPipelineConfigurationResponse(
          mediaInsightsPipelineConfiguration.map(value => value.asEditable)
        )
    def mediaInsightsPipelineConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration.ReadOnly
    ]
    def getMediaInsightsPipelineConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mediaInsightsPipelineConfiguration",
      mediaInsightsPipelineConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationResponse
  ) extends zio.aws.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationResponse.ReadOnly {
    override val mediaInsightsPipelineConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaInsightsPipelineConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationResponse
  ): zio.aws.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
